import java.io.*;
import java.awt.*;
import java.awt.event.*;
import com.ibm.cf.*;

/**
 * @version 1.0
 * @author Matthew J. Duftler
 */
public class Demo
{
  private static final String TITLE           = "CodeFormatter Demo";
  private static final String FONT_NAME       = "Monospaced";
  private static final String DEMO_FILE_NAME  = "demo.in";
  private static final int    FONT_SIZE       = 12;

  private CodeFormatter cf         = new CodeFormatter();
  private TextArea      sourceArea = new TextArea();
  private TextArea      targetArea = new TextArea();
  private Button        formatBtn  = new Button("Format");

  public Demo()
  {
    Frame frame = new Frame(TITLE);
    frame.setLayout(new GridBagLayout());
    frame.setFont(new Font(FONT_NAME, Font.PLAIN, FONT_SIZE));
    frame.addWindowListener(
      new WindowAdapter()
      {
        public void windowClosing(WindowEvent e)
        {
          System.exit(0);
        }
      }
                           );

    sourceArea.setText(getFileContent(DEMO_FILE_NAME));

    Panel btnPanel = new Panel(new GridBagLayout());
    GridBagConstraints cons = new GridBagConstraints();
    btnPanel.add(formatBtn, cons);
    formatBtn.addActionListener(
      new ActionListener()
      {
        public void actionPerformed(ActionEvent e)
        {
          StringReader source = new StringReader(sourceArea.getText());
          StringWriter target = new StringWriter();

          cf.formatCode(source, target);

          targetArea.setText(target.toString());
        }
      }
                               );

    cons.fill = GridBagConstraints.BOTH;
    cons.weightx = 1;
    cons.weighty = 1;
    frame.add(sourceArea, cons);
    cons.fill = GridBagConstraints.NONE;
    cons.weightx = 0;
    frame.add(btnPanel, cons);
    cons.fill = GridBagConstraints.BOTH;
    cons.weightx = 1;
    frame.add(targetArea, cons);

    frame.pack();
    frame.show();
  }

  public String getFileContent(String fileName)
  {
    try
    {
      BufferedReader in  = new BufferedReader(new FileReader(fileName));
      StringWriter   sw  = new StringWriter();
      PrintWriter    out = new PrintWriter(sw);
      String         tempLine;

      while ((tempLine = in.readLine()) != null)
      {
        out.println(tempLine);
      }

      out.flush();

      return sw.toString();
    }
    catch (IOException e)
    {
      return "";
    }
  }

  public static void main(String[] argv)
  {
    new Demo();
  }
}
