import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
import java.net.*;

/**
*
* SplashScreen zeigt einen Programmstart-Bildschirm mit Textzeile, 
* Bildemblem und Fortschrittsbalken.
*
*/
public class SplashScreen extends JWindow implements Runnable
{
	protected JProgressBar progressBar;
	protected JLabel splashScreenLabel;
		
	/**
	* Konstruktor - sorgt fr die Initialisierung aller Komponenten
	* und besorgt den Bildschirmaufbau.
	*
	* @param image URL oder Dateipfad zum Bildemblem (Bild im GIF- oder JPEG-Format)
	*/
	public SplashScreen( String img )
	{
		JPanel splash = new JPanel(new BorderLayout());

		JPanel centerPanel = new JPanel( new BorderLayout() );
		centerPanel.setBackground( Color.black );
		// Bildemblem wird geholt und eingefuegt
		URL url = getClass().getResource( img );
		if(url != null)
		{
			centerPanel.add(new JLabel(new ImageIcon(url)),
				BorderLayout.CENTER);
		}
		
		// Textlabel wird angelegt
		splashScreenLabel = new JLabel(" ");
		splashScreenLabel.setFont( new Font( "Sans Serif", Font.PLAIN, 11 ) );
		splashScreenLabel.setForeground( Color.white );				

		centerPanel.add( splashScreenLabel, BorderLayout.SOUTH);
		
		// Fortschrittsbalken wird angelegt
		progressBar = new JProgressBar(0,100);
		progressBar.setValue(0);
		splash.add( progressBar, BorderLayout.SOUTH);
		
		
splash.add( centerPanel, BorderLayout.CENTER );

		// Rahmen wird angelegt
		splash.setBorder( new EtchedBorder() );
/*		splash.setBorder(new CompoundBorder(
			new SoftBevelBorder(BevelBorder.RAISED),
			new CompoundBorder(new EmptyBorder(1,1,1,1),
			new SoftBevelBorder(BevelBorder.LOWERED)))); 
*/			
			
		setContentPane(splash);
		
		// Zentrierte Position wird berechnet
		pack();
		Dimension screen = getToolkit().getScreenSize();
		setLocation((screen.width - getSize().width) / 2,
			(screen.height - getSize().height) / 2);
	}

	/**
	*
	* Setzt die Textzeile neu.
	* @param ltext Linker Teil der Textzeile fr den Splash-Screen
	* @param rtext Rechter Teil der Textzeile fr den Splash-Screen
	* @param pos  neue Position fr den Fortschrittsbalken
	* @param sleep Pause innerhalb des Ablaufs
	*/
	public void setText( String ltext, String rtext, int pos, int sleep ){

		int labelWidth = splashScreenLabel.getWidth();
		Font font = splashScreenLabel.getFont();
		FontMetrics fm = splashScreenLabel.getGraphics().getFontMetrics( font );
		int leftWidth = fm.stringWidth( ltext );
		int rightWidth = fm.stringWidth( rtext );
		int emptyWidth = fm.charWidth(' ');

		int emptyCount = labelWidth - leftWidth - rightWidth -2*emptyWidth;
		
		String emptyString = "";
		if( rtext.length() > 0 ) {
			for( int i = emptyCount; i > 0; i -= emptyWidth ){
				emptyString += " ";
			}
		}

		splashScreenLabel.setText( " "+ltext+emptyString+rtext );
		progressBar.setValue(pos);

		// Zwangspause, damit der Text nicht zu schnell veraendert werden kann.
		if( sleep > 0 ) {
			try {
				Thread.sleep( sleep );
			}
			catch( InterruptedException e ){}
		}
	}
	
	/**
	*
	* Setzt die Textzeile neu.
	* @param text neue Textzeile fr den Splash-Screen
	* @param pos  neue Position fr den Fortschrittsbalken
	*/
	public void setText( String text, int pos ) {
		this.setText( text, "", pos, 500 );
	}
	
	/**
	* Hauptschleife fr einen automatischen Durchlauf des Splashscreen-Threads
	*/
	public void run() {
		
		Thread t = new Thread( this );
		
		this.setVisible(true);
		
		try {			
			for(int i=0; i <= 100; i++) {
				progressBar.setValue(i);
				t.sleep(100);
			}
		}
		catch( InterruptedException e ) {}
	}
}
