public abstract class SortedList {
	
	private Link first;
	private Link cur;
	
	public SortedList() {
		first = cur = null;
	}
	
	public void insert( Object oRef ) {
		Link tempLinkRef = new Link( oRef );
		
		Link previous = null;
		Link current = first;
		
		while( current != null && compare( oRef, current.dataRef ) > 0 ) {
			previous = current;
			current = current.next;	
		}
		
		if( previous==null )
			first = tempLinkRef;
		else 
			previous.next = tempLinkRef;

		tempLinkRef.next = current;
	}
	
	public abstract int compare( Object obj1Ref, Object obj2Ref );
	
	public Link remove(){
		Link tempLinkRef = first;
		first = first.next;
		return tempLinkRef;
	}
	
	public Object getNextDataObject() {
	
		if( cur == null )
			cur = first;
		else
			cur = cur.next;
		
		if( cur != null )	
			return( cur.dataRef );
		else
			return( null );
	}			
}

class Link {
	public Object dataRef=null;
	public Link next=null;
		
	public Link( Object oRef ) {
		dataRef = oRef;
	}	
}