import java.awt.*;

import javax.swing.*;

import javax.swing.event.*;

import java.util.*;

import java.io.*;



public class NekjeWBPanel extends JPanel implements ChangeListener {



    public JTabbedPane wbTabs = null;

    public NekjeActionSet actionSet;



    private Nekje app;

    private int tabCounter;

    protected NekjeIndentClass indentObject=null;

    NekjeWBPanel( Nekje app ) {

        this.app = app;

        loadIndentPlugin();

        actionSet = new NekjeActionSet( this );

        tabCounter = 0;



        wbTabs = new JTabbedPane();

        wbTabs.addChangeListener( this );



        setLayout( new BorderLayout() );

        add(wbTabs, BorderLayout.CENTER);

    }



    public void stateChanged( ChangeEvent e ) {



        if( wbTabs.getSelectedIndex() != -1 ) {

            getCurrentEditor().activateEditor();

        }

    }



    /**

    *	Setzt Titel neu bei Veraenderung des Editorinhalts

    */

    public void changedUpdate() {

        wbTabs.setTitleAt(wbTabs.getSelectedIndex(),

        wbTabs.getTitleAt(wbTabs.getSelectedIndex()) + "*" );

    }



    public Nekje getApplication() {

        return app;

    }



    public Properties getProperties() {

        return app.props;

    }



    public NekjeScrollEditorPanel getEditorAt( int idx ) {

        return( (NekjeScrollEditorPanel)wbTabs.getComponentAt( idx ) );

    }



    public NekjeScrollEditorPanel getCurrentEditor() {

        return( getEditorAt( wbTabs.getSelectedIndex() ) );

    }



    public NekjeTextArea getCurrentTextArea() {

        return (NekjeTextArea)(

            (NekjeScrollEditorPanel)wbTabs.getSelectedComponent

            ()).getTextArea();

    }



    public String getCurrentTextToken() {

        return( getCurrentEditor().getCaretText() );

    }



    public NekjeReference getReferenceBrowser() {

        return app.getReferenceBrowser();

    }



    public boolean hasTab() {

        return ( wbTabs.getTabCount() > 0 ? true : false );

    }



    public int getTabCount() {

        return( wbTabs.getTabCount() );

    }



    public void addNewTab() {

        tabCounter++;

        String tempFileName = "Datei " + tabCounter;

        NekjeScrollEditorPanel ta = new NekjeScrollEditorPanel(this,null,

            null,true);

        wbTabs.addTab( tempFileName, ta );



        // Setze Focus in das Editorfenster

        wbTabs.setSelectedIndex( wbTabs.getTabCount()-1 );

        ta.activateEditor();

    }



    public void addOpenTab() {



        NekjeFileDialog fd = new NekjeFileDialog(app , FileDialog.LOAD,

        (String)(app.getProperties().getProperty("workingDirectory")),

        null );



        if( fd.getFile() != null ) {

            NekjeScrollEditorPanel ta =

            new NekjeScrollEditorPanel( this, fd.getDirectory(),

                fd.getFile(), false );



            wbTabs.addTab( fd.getFile(), ta );

            wbTabs.setSelectedIndex( wbTabs.getTabCount()-1 );

            //		updateActionSet();

            // Setze Focus in das Editorfenster

            ta.activateEditor();

            // Setze Working-Directory neu

            app.getProperties().setProperty("workingDirectory",

                fd.getDirectory() );

        }

    }



    public boolean activateTab( String fname ) {

        for(int i=0; i < getTabCount(); i++){

            if( fname.equals( getFileNameAt(i) ) ) {

                wbTabs.setSelectedIndex( i );

                getEditorAt(i).activateEditor();

                return true;

            }

        }

        return false;

    }



    public void gotoLine( int line ){

        getCurrentEditor().setFirstLine( line );

    }



    public boolean closeSelectedTab( boolean save ) {



        boolean status = true;



        if( hasTab() ) {



            if( save )

            status = changedDialog();



            if( status == true ) {

                wbTabs.removeTabAt( wbTabs.getSelectedIndex() );

                //				updateActionSet();

            }

        }



        return(status);

    }



    public boolean closeAllTabs() {

        boolean status = true;



        while( status == true && hasTab() ) {

            status = closeSelectedTab( true );

        }



        return( status );

    }



    /**

    * Zentrale Speicher-Funktion, durch die alle Speichervorgaenge laufen.

    * Speichert den Inhalt des ausgewaehlten Editorfensters.

    */

    public boolean saveTabAt( int idx, String fDir, String fFile ) {



        boolean status = false;



        NekjeScrollEditorPanel temp = getEditorAt( idx );



        if( temp != null && temp.saveFile( fDir, fFile ) ) {

            wbTabs.setTitleAt( idx, fFile );

            temp.setFFileName( fFile );

            temp.setFDirName( fDir );

            temp.setEditFlag( false );

            status = true;

        }

        return status;

    }



    /**

    *	Speichert den Inhalt des aktivierten Editorfensters.

    */

    public void saveCurrentTab( String fDir, String fFile ) {

        saveTabAt( wbTabs.getSelectedIndex(), fDir, fFile );

    }



    /**

    *

    */

    public boolean resaveTabAt( int idx ) {

        NekjeScrollEditorPanel temp = getEditorAt(idx);



        if( temp.getEditFlag() == true );

        {

            String cFile = getFileNameAt( idx );



            if( temp.getSaveFlag() == false ) {

                // Datei ist neu, es gibt noch keine Sicherung

                String cName = temp.getClassName();



                if( cName != null && cName.length() > 0 ) {

                    return( saveDialog( idx, app.getProperties

                        ().getProperty("workingDirectory"),

                    cName + ".java" ) );

                }

                else {

                    return( saveDialog( idx, app.getProperties

                        ().getProperty("workingDirectory"),

                    cFile ) );

                }

            }

            // Es existiert bereits eine Sicherung

            else

            return( saveTabAt( idx, getDirAt(idx), cFile ) );

        }

    }



    public boolean resaveCurrentTab() {

        return( resaveTabAt( wbTabs.getSelectedIndex() ) );

    }



    public void saveAs() {

        saveDialog( wbTabs.getSelectedIndex(),

        app.getProperties().getProperty("workingDirectory"),

        getCurrentFileName()  );

    }



    public boolean saveDialog( final int idx, final String fdir,

        final String fname ) {



        boolean status = false;

        boolean dialogDone = false;

        String fileName = fname;

        String fileDir = fdir;



        while( dialogDone != true ) {

            final NekjeFileDialog fd = new NekjeFileDialog( app,

                FileDialog.SAVE, fileDir, fileName );



            fileName = fd.getFile();

            fileDir = fd.getDirectory();

            dialogDone = true;



            if( fileName != null ) {

                // Check die Endung

                if( fileName.indexOf('.') == -1 ) {

                    // Keine Dateiendung entdeckt

                    int rv = javaExtensionDialog( fileName );



                    if( rv == 0 ){

                        fileName = fileName + ".java";

                    }

                    else if( rv == 2 ) {

                        dialogDone = false;

                    }

                }

            }

        }



        if( fileName != null ) {

            status = saveTabAt( idx, fileDir, fileName );



            if(status == true)

            {

                app.getProperties().setProperty("workingDirectory",

                fileDir );

            }

        }



        return(status);

    }



    private int javaExtensionDialog( String fname ) {

        Object[] possibleValues = { "Ja", "Nein", "Abbrechen" };



        return JOptionPane.showOptionDialog(

        this, "Soll die Dateiendung \".java\" ergnzt werden",

        "Warnung: " + fname + " - fehlende Dateiendung",

        JOptionPane.YES_NO_CANCEL_OPTION,

        JOptionPane.WARNING_MESSAGE,

        null, possibleValues, possibleValues[0] );



    }



    public boolean changedDialog() {



        boolean status = true;



        if( getCurrentEditor().getEditFlag() == true ) {

            status = saveBeforeActionDialog(

            "Sie haben Vernderungen vorgenommen. Wollen Sie diese zunchst speichern?"

                ,

            getCurrentFileName() );

        }

        return(status);

    }



    public void noJavaFile() {

        errorDialog(

            "Die gewhlte Funktion verlangt zwingend eine geffnete Datei\n"

            +

        "mit der Dateiendung .java im aktiven Karteifenster.");

    }



    public void errorDialog( String msg ) {

        JOptionPane.showMessageDialog( this, msg, "Fehler",

            JOptionPane.ERROR_MESSAGE);

    }



    public boolean isJavaFile() {

        boolean status = true;



        if(    getCurrentFileName().endsWith(".java") == false ) {

            JOptionPane.showMessageDialog( this,

                "Speichern Sie die Datei mit der Endung .java!",

            "Fehler", JOptionPane.ERROR_MESSAGE);



            status = false;

        }



        return( status );

    }



    public boolean verifyFileName() {

        String fileName = getCurrentFileName();

        String className = fileName.substring( 0, fileName.lastIndexOf(

            ".java") );



        if( fileContainsClass( className ) == false ){

            errorDialog( "Die Datei " + fileName +

                " enthlt nicht die Klasse " + className+

            ". Gefundener Klassenname: "+getCurrentEditor().getClassName

                () );

            return( false );

        }



        return( true );

    }



    public boolean saveBeforeActionDialog(String msg, String title) {



        boolean status = false;



        Object[] possibleValues = { "Speichern", "Nicht Speichern",

            "Abbrechen" };



        int selectedValue = JOptionPane.showOptionDialog(



        this, msg, title, JOptionPane.YES_NO_CANCEL_OPTION,

            JOptionPane.QUESTION_MESSAGE,

        null, possibleValues, possibleValues[0] );



        if( selectedValue == 0 )

        status = resaveCurrentTab();



        else if( selectedValue == 1 )

        status = true;



        return( status );

    }



    public String getParameterDialog() {

        return( JOptionPane.showInputDialog(this,

        "Welche Parameter wollen Sie an das Programm bergeben?") );

    }



    public String getCurrentFileName() {

        return( getCurrentEditor().getFFileName() );

    }



    public String getCurrentFile() {

        NekjeScrollEditorPanel temp = getCurrentEditor();

        return( temp.getFDirName() + temp.getFFileName() );

    }



    public String getCurrentDir() {

        return( getCurrentEditor().getFDirName() );

    }



    public String getFileAt( int idx ) {

        NekjeScrollEditorPanel temp = getEditorAt(idx);

        return( temp.getFDirName() + temp.getFFileName() );

    }



    public String getDirAt( int idx ) {

        NekjeScrollEditorPanel temp = getEditorAt( idx );

        return( temp.getFDirName() );

    }



    public String getFileNameAt( int idx ) {

        NekjeScrollEditorPanel temp = getEditorAt( idx );

        return( temp.getFFileName() );

    }



    public NekjeDocument getCurrentDocument() {

        return( getCurrentEditor().getDocument() );

    }



    public NekjeConsole getConsole() {

        return app.getConsole();

    }



    public String getClassName() {

        return( getCurrentEditor().getClassName() );

    }



    public boolean fileContainsClass( String className ) {

        return( getCurrentEditor().fileContainsClass( className ) );

    }





    public void insertBlock( String text, int newpos ) {

        getCurrentEditor().insertBlock( text, newpos );

    }



    public void processCommand( final String command ) {

        Thread runner = new Thread() {

            public void run() {

                try {

                    Process p = Runtime.getRuntime().exec(command);

                }

                catch( IOException ex ) {

                }

            }

        };

        runner.start();

    }



    public void createHTML( String dirName, String className ) {



        String text = "<html>\n<!-- HTML-Testdatei fuer Java-Applet "

            + className + "-->\n" +

        "<body>\n<applet code=\"" + className + ".class\" " +

        "width=\"400\" height=\"200\">\n</applet>\n</body>\n</html>\n";



        String tFName = className+ ".htm";

        int idx = wbTabs.getSelectedIndex();



        NekjeScrollEditorPanel temp = getCurrentEditor();

        wbTabs.setTitleAt( idx, tFName );

        temp.setFFileName( tFName );

        temp.setFDirName( dirName );

        getCurrentEditor().insertBlock( text, 0 );

    }



    public boolean loadIndentPlugin() {



        boolean status = false;



        String indentPluginURL =

        app.getProperties().getProperty("indentPluginURL");

        String indentPluginClass = app.getProperties().getProperty(

            "indentPluginClass");



        if( indentPluginURL != null && indentPluginClass != null ) {

            try {

                // Wrapper-Klassen muessen den Klassennamen + "PluginWrapper" tragen!!!!

                String indentPluginName = "";



                try {

                    // Trenne classpath von Class-Name

                    indentPluginName = indentPluginClass.substring(

                    indentPluginClass.lastIndexOf('.')+1 );

                }

                catch( IndexOutOfBoundsException eb ) {

                    indentPluginName = indentPluginClass;

                }



                if( indentPluginName.length() > 0 ) {

                    String indentPluginWrapper = indentPluginName+

                        "PluginWrapper";



                    Class indentClass = Class.forName

                        (indentPluginWrapper);



                    this.indentObject =

                    (NekjeIndentClass)indentClass.newInstance();

                    this.indentObject.setURL( indentPluginURL );

                    this.indentObject.setClassName( indentPluginClass );

                    this.indentObject.loadPlugin();



                    status = this.indentObject.isValid();

                }

            }

            catch( Exception e ) {

                System.err.println( e.toString() );

                status = false;

            }

        }



        if( status == false && this.indentObject != null )

        indentObject = null;

        return(status);

    }



    public void indent() {



        if( indentObject != null ) {

            try {

                String text = getCurrentEditor().getText();



                ByteArrayInputStream in = new ByteArrayInputStream

                    (text.getBytes());

                ByteArrayOutputStream out = new ByteArrayOutputStream();



                indentObject.parse(in,out);

                text = out.toString();

                getCurrentEditor().setText(text);

            }

            catch( Exception e ) {

            }

        }

    }



    public NekjeIndentClass getIndentPlugin() {

        return indentObject;

    }

}



