import java.awt.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.event.*;
import javax.swing.undo.*;
import java.io.*;
import java.util.*;

public class NekjeTextArea extends JEditTextArea {

	final UndoManager undo = new UndoManager();

	public NekjeTextArea( TextAreaDefaults def, Properties pr ){
		super( def );
		
		// Setze Nekje-Font
		try {
			
			int fontsize = Integer.parseInt( pr.getProperty("nekjeFontsize") );
			int fontstyle = Font.PLAIN;
			
			if( pr.getProperty("nekjeFonttype").equals("BOLD") ) fontstyle = Font.BOLD;
			else if( pr.getProperty("nekjeFonttype").equals("ITALIC") ) fontstyle = Font.ITALIC;
			
			getPainter().setFont(
				new Font(
					pr.getProperty("nekjeFont"),
					fontstyle,
					fontsize
				)
			);
		}
		catch( NumberFormatException e ){
			System.err.println( "Fehler beim Setzen des Schriftfonts: " + e.getMessage() );	
		}			
	
    		Document doc = getDocument();
    
    		doc.addUndoableEditListener(new UndoableEditListener() {
        		public void undoableEditHappened(UndoableEditEvent evt) {
            			undo.addEdit(evt.getEdit());
        		}
    		});
	}
	

	public void undo() {
                try {
                    if (undo.canUndo()) {
                        undo.undo();
                    }
                } 
                catch (CannotUndoException e) {
                }	
	}
	
	public void redo() {
	        try {
                    if (undo.canRedo()) {
                        undo.redo();
                    }
                } 
                catch (CannotRedoException e) {
                }	
	}
}
