import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import java.io.*;
import java.util.*;

import gnu.regexp.*;

public class NekjeScrollEditorPanel extends JPanel implements DocumentListener {
	
	protected NekjeTextArea ta;
	protected TextAreaDefaults def;
	protected JPanel statusPanel;
	protected JLabel rcLabel;
	protected JLabel statusLabel;
	
	private NekjeWBPanel wbRef;
	private String fName;
	private String fDir;
	
	private boolean editFlag=false;
	private boolean saveFlag=false; // Zeig an, ob der aktuelle Editorinhalt bereits gespeichert wurde.
	
	private RE re=null; // RegularExpression fuer getClassName()
	private final String classSearchString = "public\\s+((static|abstract)\\s+)*((class|interface)\\s+)\\w+";
		
	public NekjeScrollEditorPanel(
		NekjeWBPanel wbRef, 
		String fDir, 
		String fName,
		boolean blankWindow
	) {
		this.wbRef = wbRef;
		this.fName = fName;
		this.fDir = fDir;
		
		ta = new NekjeTextArea( getNekjeTextAreaDefaults(), wbRef.getProperties() );
		
		if( !blankWindow ) {
			readFile();
		}
		else {
			setSaveFlag(false);	
		}
		
		// Statuszeile konstruieren
		statusPanel = new JPanel();
		
		rcLabel = new JLabel(" Zeile:    1 Position:   1 ");
		statusLabel = new JLabel();
				
		statusPanel.setLayout( new BorderLayout() );
		statusPanel.add(rcLabel, BorderLayout.WEST);
		statusPanel.add(statusLabel, BorderLayout.EAST);
		
		// EditorPanel konstruieren
		setLayout( new BorderLayout() );
		ta.add(ta.LEFT_OF_SCROLLBAR,statusPanel);
		add(ta, BorderLayout.CENTER );

		getDocument().addDocumentListener( this );
		
		ta.addCaretListener( new CaretListener() {
			public void caretUpdate( CaretEvent e ) {
	
				Element elem = def.document.getDefaultRootElement();
				int pos = ta.getCaretPosition();
				int idx = ta.getCaretLine();
				Element cElem = elem.getElement(idx);
				int start = cElem.getStartOffset();
									
				rcLabel.setText(" Zeile: " + (idx+1) + " Position: " + (pos-start+1)+" " );
			}
		});
		
		try {
			re = new RE( classSearchString );
		}
		catch( Exception e ) {
			re = null;
		}	
	}
	
	public void changedUpdate( DocumentEvent e ){
		if( getEditFlag() == false ) {
			setEditFlag(true);
			wbRef.changedUpdate();
		}
	}
	 
	public void insertUpdate( DocumentEvent e){
		changedUpdate( e );
	}
	
	public void removeUpdate( DocumentEvent e){
		changedUpdate( e );
	} 
	
	private TextAreaDefaults getNekjeTextAreaDefaults () {
	
		def = new TextAreaDefaults();
		def.inputHandler = new DefaultInputHandler();
		def.inputHandler.addDefaultKeyBindings();
		def.document = new NekjeDocument();
		def.editable = true;

		def.caretVisible = true;
		def.caretBlinks = true;
		def.electricScroll = 3;

		def.cols = 80;
		def.rows = 25;
		def.styles = setNekjeSyntaxStyles();
		def.caretColor = Color.red;
		def.selectionColor = new Color(0xccccff);
		def.lineHighlightColor = new Color(0xe0e0e0);
		def.lineHighlight = true;
		def.bracketHighlightColor = Color.black;
		def.bracketHighlight = true;
		def.eolMarkerColor = new Color(0x009999);
		def.eolMarkers = true;
		def.paintInvalid = true;			
		
		return( def );
	}
	

	public SyntaxStyle[] setNekjeSyntaxStyles()
	{
		SyntaxStyle[] styles = new SyntaxStyle[Token.ID_COUNT];

		styles[Token.COMMENT1] = new SyntaxStyle(Color.lightGray,true,false);
		styles[Token.COMMENT2] = new SyntaxStyle(new Color(0x990033),true,false);
		styles[Token.KEYWORD1] = new SyntaxStyle(Color.blue,false,true);
		styles[Token.KEYWORD2] = new SyntaxStyle(Color.magenta,false,false);
		styles[Token.KEYWORD3] = new SyntaxStyle(Color.blue,false,true);
		styles[Token.LITERAL1] = new SyntaxStyle(new Color(0x650099),false,false);
		styles[Token.LITERAL2] = new SyntaxStyle(new Color(0x650099),false,true);
		styles[Token.LABEL] = new SyntaxStyle(new Color(0x990033),false,true);
		styles[Token.OPERATOR] = new SyntaxStyle(Color.black,false,true);
		styles[Token.INVALID] = new SyntaxStyle(Color.red,false,true);

		return styles;
	}
	
	
	/**
	*	Besorgt Referenz auf das Editorfenster.
	*/
	public NekjeTextArea getTextArea() {
		return ta;
	}
	
	/**
	*	Setzt den Focus auf das Editorfenster.
	*/
	public void activateEditor() {
		ta.requestFocus();
	}

	public void setFirstLine( int line ) {
		ta.setCaretPosition( ta.getLineStartOffset(line) );
	}
	

	private boolean readFile() {
		boolean status = false;
		
		if( ta != null && fName != null && fName.length() > 0 ) {
			
			try {
				String filePath = (fDir != null ? fDir : ".") + fName;
					
				FileReader in = new FileReader( new File( filePath ) );	
				
				// Zunaechst einlesen der Inhalte in einen StringBuffer
				
				char[] tbuf = new char[8000];
				StringBuffer tsrt = new StringBuffer(8000);
				int rc;
				
				do {
					rc = in.read( tbuf, 0, tbuf.length );
					if( rc > 0 ) {
						tsrt.append( tbuf, 0, rc );
					}						
				} while( rc != -1 );
				
				// Jetzt uebertragen in die Textarea
					
				ta.setText( tsrt.toString() );
				in.close();	
				ta.setCaretPosition(0);
				setTokenMarker( ta, fName );
				setSaveFlag(true);	
			}
			catch( IOException e ) {
				
			}
		}
		return status;	
	}

	/**
	* LowLevel-Datei-Speichern
	*/
	public boolean saveFile( String fDir, String fFile ) {
			
			boolean status = false;
			
			String tstr = ta.getText();
			try {
				FileWriter out = new FileWriter( new File(fDir + fFile) );
				out.write( tstr, 0, tstr.length() );
				out.close();
				status = true;
			}
			catch( IOException e ) {
			}
			
			setSaveFlag(true);
			
			// Versuche den TokenMarker zu setzen
			if( ta.getTokenMarker() == null ) {
				setTokenMarker( ta, fFile );
			}
			
			return status;
	}
	
	private void setTokenMarker( NekjeTextArea area, String filename ) {
	
		if( filename.endsWith(".java") ) area.setTokenMarker( new JavaTokenMarker() );
		else if ( filename.endsWith(".htm") || filename.endsWith(".html") ) {
			area.setTokenMarker( new HTMLTokenMarker() );
		}			
	}
	
	public String getText() {
		return ta.getText();
	}
	
	public void setText( String str ){
		ta.setText( str );
	}
	
	public String getCaretText() {
		NekjeDocument tdoc = (NekjeDocument)getDocument();
		
		return( tdoc.getCurrentToken( ta.getCaretPosition() ) );
	}

	public void setFFileName( String name ) {
		fName = name; 
	}

	public String getFFileName() {
		return( fName );
	}
	public void setFDirName( String name ) {
		fDir = name;
	}
	public String getFDirName() {
		return( fDir );
	}
	public void setEditFlag( boolean flag ) {
		editFlag = flag;
	}
	
	public boolean getEditFlag() {
		return( editFlag );
	}
	
	public void setSaveFlag( boolean flag ) {
		saveFlag = flag;
	}

	public boolean getSaveFlag() {
		return( saveFlag );
	}

	public NekjeDocument getDocument() {
		return( (NekjeDocument)def.document );
	}
	
	public String getClassName() {
		String className = null;
		
		if( re != null ) {
			
			String tstr = ta.getText();
			REMatch match = re.getMatch( tstr );
			
			if( match != null ) {
				String matchStr = match.toString();
				className = matchStr.substring( matchStr.lastIndexOf(' '));
				className = className.trim();
			}
		}
		return className;	
	}
	
	public boolean fileContainsClass( String className ) {
			return className.equals( getClassName() );
	}

	public void insertBlock( String text, int newpos ) {

		int pos = ta.getCaretPosition();
		NekjeDocument tdoc = (NekjeDocument)getDocument();

		int npos = tdoc.insertBlock( text, pos, newpos );

		ta.setCaretPosition( npos );
	}
}
																																																																																