import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.html.*;
import java.util.*;
import java.io.*;
import java.net.*;

public class NekjeReference extends JFrame implements HyperlinkListener{
	protected JFrame parentFrame;
	protected KlassenReferenz reference;
	protected JTextField  eingabeFeld;
	protected JButton sucheButton;
	protected JEditorPane ausgabeArea;
	protected String apiDocPath;
	protected String refSrc;
	protected Properties refProps;
	protected Properties sysProps;

    public NekjeReference() {
    	
    	reference = new KlassenReferenz();
    	setTitle("Nekje-Referenz");
		getContentPane().setLayout(new BorderLayout());

		JPanel eingabePanel = new JPanel();
		
		eingabePanel.add(new JLabel("Suchbegriff: "));

		eingabeFeld = new JTextField(20);

		eingabeFeld.addActionListener(new ActionListener() {

			    public void actionPerformed(ActionEvent e) {
			    	processAction(eingabeFeld.getText());
		    } 

	});
	
	eingabePanel.add(eingabeFeld);
	
	sucheButton = new JButton("Suchen");
	
	sucheButton.addActionListener( new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			String input = ausgabeArea.getSelectedText();
			
			if( input == null || input.length() == 0 ) {
				input = eingabeFeld.getText();
			}
			
		    	processAction(input);
	    	} 
		
	});
		
	eingabePanel.add(sucheButton);
		
	getContentPane().add(eingabePanel, BorderLayout.NORTH);

	ausgabeArea = new JEditorPane("text/html", "");

	ausgabeArea.setEditable(false);
	ausgabeArea.addHyperlinkListener(this);
	setAusgabeText("<html><body>Geben Sie den Namen einer Klasse im Eingabefeld ein!</body></html>");
	JScrollPane sr = new JScrollPane(ausgabeArea);

	getContentPane().add(sr, BorderLayout.CENTER);
	this.addWindowListener(new WindowAdapter() {

	    public void windowClosing(WindowEvent e) {
	    	if( parentFrame != null )
	    		setVisible(false);
	    	else	
			System.exit(0);
	    } 

	});
	
	sysProps = System.getProperties();		

    }

    public void setParent( JFrame pp ) {
    
    	parentFrame = pp;

    }

	public void setClassPath( String cp ) {
		reference.setClassPath( cp );
	}
	
	public void setReferenceSource( String dataSource ) {
		refSrc = dataSource;
		
		refProps = new Properties();
		
		loadProperties( refProps, dataSource );
		
		apiDocPath = refProps.getProperty("apiDocs");
		reference.setApiDocPath( apiDocPath );		
	}
	
	
	protected void loadProperties( Properties pr, String resrc ) {
		try {
			URL src = new URL( resrc );
			pr.load( (InputStream)src.getContent() );
						
		}
		catch( Exception e ) {
			// Problem beim Laden der Resource
			try {
				pr.load( new FileInputStream(resrc) );
			}
			catch( Exception ex ) {			
			}		
		}	
	}

    public void hyperlinkUpdate(HyperlinkEvent e) {
		try {
		    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
		    		eingabeFeld.setText("");
				JEditorPane pane = (JEditorPane) e.getSource();

				if (e instanceof HTMLFrameHyperlinkEvent) {
				    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent) e;
				    HTMLDocument doc = (HTMLDocument) pane.getDocument();

				    doc.processHTMLFrameHyperlinkEvent(evt);
				} else {
				    try {
					pane.setPage( e.getURL() );
				    } catch (Throwable t) {}
				} 
		    } 
		} catch (Exception ex) {} 
    } 

	public void processAction( String input ) {
		
		eingabeFeld.setText("");

		if( input != null ) {			
			if( input.endsWith("\n") ) {
				StringBuffer in = new StringBuffer(input);
				in.deleteCharAt( in.length()-1 );
			
				input = in.toString();
			}
		
			if( input.length() > 0 ) {
				getReference( input );
				eingabeFeld.setText( input );
			}
			else
				eingabeFeld.setText( "Kein Suchbegriff definiert...");	
		} 
	}

	public void setAusgabeText( String info ) {
			ausgabeArea.setContentType("text/html");
			ausgabeArea.setText( info );	
			ausgabeArea.setCaretPosition(0);	
	}
	
	private	static final String[] tb = {
			"<td valign=\"top\" nowrap><font size=2>",
			"<td><font size=2 color=\"#0000ff\">",
			"</font></td>"
		};

	public void getReference( String sName ) {
		boolean done = false;
		String pValue = null;
		
		eingabeFeld.setText( sName );
		
		// 1. ggfs. Anzeige definierter Properties
		if( refProps != null ) {
					
			pValue = refProps.getProperty( sName );
			
					
			if(pValue != null) {
				try {
					// setContentType ist uebler Trick, um einen
					// Bug beim wiederholten Laden der HTML-Dokumente
					// zu umgehen
					ausgabeArea.setContentType("text/plain");
					ausgabeArea.setPage( new URL(pValue) );
				}
				catch( Exception e ) {
					setAusgabeText("Fehler beim Laden von " + pValue +
					"(" + e.toString() + ")");
				}
				done = true;
			}
			
		}	
			
		if( done != true && sysProps != null) {
			
			String sys = "";
				
			if( sName.equals("about") ){
					
				for (Enumeration e = sysProps.propertyNames();
				 			e.hasMoreElements() ;) {
       					String key = (String)e.nextElement();
       					sys += "<tr>"+tb[0]+key + ":"+tb[2]+tb[1]+ sysProps.getProperty(key) +tb[2]+"</tr>";
       				}
         					
       			}
       			/* Nur mit '.', damit nicht Klassen ausgesperrt werden */
       			else if (sName.indexOf('.') != -1) {
				for (Enumeration e = sysProps.propertyNames();
				 			e.hasMoreElements() ;) {
       					String key = (String)e.nextElement();
         				
       					if( key.indexOf( sName ) != -1 )
       						sys += "<tr>"+tb[0]+key +":"+tb[2]+tb[1] + sysProps.getProperty(key)+tb[2]+"</tr>";
				}
			}
				
			/* Wenn fuendig geworden, Ergebnisse ausgeben */
			if( sys.length() > 0 ) {
				showSysProperties( sys );
				done = true;
			}	
 
		}
			
		if( done != true ) {			
			setAusgabeText( "<html><body>Bitte etwas Geduld ...</body></html>" );
			setAusgabeText(	reference.getHTMLReferenz(sName) );
		}		
	}
	
	private void showSysProperties( String str ) {
		
		String ausgabeStr = "<html><body><table>" + str + "</table></font></body></html>";
		setAusgabeText( ausgabeStr );
	}
		
    public static void main(String[] args) throws ClassNotFoundException {
		NekjeReference thisApp = new NekjeReference();
		thisApp.setSize(800, 600);
		thisApp.setVisible(true);
    } 
}
				    				    				    		    	    												    										    				    				    		    	    												    										    				    				    		    	    												    											