import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class NekjeMenuBar extends JMenuBar {
	
	private NekjeWBPanel wbRef;
	
	public NekjeMenuBar ( NekjeWBPanel wbRef ) {
		this.wbRef = wbRef;
		createMenuBar();
	}
		
	private void createMenuBar() {
		
		NekjeAction[] dateiMenu = {
			wbRef.actionSet.actionNew,
			wbRef.actionSet.actionOpen,
			wbRef.actionSet.actionClose,
			wbRef.actionSet.actionResave,
			wbRef.actionSet.actionSaveAs,
                           wbRef.actionSet.actionPrint,
			null,
			wbRef.actionSet.actionExit
		};

		NekjeAction[] editMenu = {
			wbRef.actionSet.actionUndo,
			wbRef.actionSet.actionRedo,
			null,
			wbRef.actionSet.actionCut,
			wbRef.actionSet.actionCopy,
			wbRef.actionSet.actionPaste,
			wbRef.actionSet.actionDelete,
			null,
			wbRef.actionSet.actionDuplicateCode
,
			wbRef.actionSet.actionSelectAll
		};
		

		Object[][] mb = {
			{ "Datei" , dateiMenu },
			{ "Bearbeiten", editMenu }
		};
		
		// Die Menue-Punkte der Menu-Leiste
		for( int i = 0; i < mb.length; i++ ) {
			
			JMenu tmpMenu = new JMenu( (String)mb[i][0] );
			
			// Dass zugehoerige SubMenu
			if( mb[i][1] != null ) {
				NekjeAction[] tptr = (NekjeAction[])mb[i][1];
				for( int j = 0; j < tptr.length; j++) {
					
					if( tptr[j] == null )
						tmpMenu.addSeparator();
					else {
						JMenuItem jmi = tmpMenu.add( (Action)tptr[j] );		
						jmi.setAccelerator( ((NekjeAction)tptr[j]).getAccelerator() );			
					}
				}
				
			}
			add( tmpMenu );
		}
		
		// Konstruiere Tools-Menue
		if( wbRef.actionSet.actionCompile != null || wbRef.actionSet.actionRun != null ) {

			JMenu tMenu = new JMenu("Tools");
			
			if( wbRef.actionSet.actionCompile != null ) {
				tMenu.add( wbRef.actionSet.actionCompile );
			}
			if( wbRef.actionSet.actionRun != null ) {
					tMenu.add( wbRef.actionSet.actionRun );
			}

			
			if( wbRef.actionSet.actionRunParam != null ) {
				tMenu.add( wbRef.actionSet.actionRunParam );
			}
				
			if(  ( wbRef.getProperties().getProperty("appletviewerExe") != null ) ||
				( wbRef.getIndentPlugin() != null ) ) {
			
				tMenu.addSeparator();
						
				if( wbRef.getProperties().getProperty("appletviewerExe") != null ) {
					tMenu.add( wbRef.actionSet.actionHTML);
				}
		
				if( wbRef.getIndentPlugin() != null ) {
					String indentPluginClass = 
						wbRef.getProperties().getProperty("indentPluginClass");
					wbRef.actionSet.actionIndent.putValue( Action.NAME,
					"Code ordnen (" + indentPluginClass + ")" 
					);
					tMenu.add( wbRef.actionSet.actionIndent );
				}
			}


			add( tMenu );
		}
		
		// Konstruiere Quelltext-Menu

		if( wbRef.actionSet.actionCodeSnippet != null && wbRef.getApplication().getCodeSnippets() != null ) {

			JMenu qMenu = new JMenu("Quelltext", true);
			NekjeCodeSnippets codeSnippets = wbRef.getApplication().getCodeSnippets();
			int count = codeSnippets.size();
			for( int i=0; i < count; i++ ) {
				String snippetKey = codeSnippets.getKeyAt(i);

				if( snippetKey.equals("Separator") ) {
					qMenu.addSeparator();
				}
				else {
					JMenuItem tItem = new JMenuItem( snippetKey );
					tItem.setActionCommand( snippetKey );
					tItem.addActionListener( wbRef.actionSet.actionCodeSnippet );
					qMenu.add(tItem);
				}
			}
			add( qMenu );
		}


		add( Box.createHorizontalGlue() );
			
		JMenu menu_help = new JMenu("Hilfe");
		
		if( wbRef.getProperties().getProperty("docURL") != null && 
			wbRef.getProperties().getProperty("browserExe") != null ) {
			menu_help.add( wbRef.actionSet.actionViewDoc );
		}
		
		menu_help.add( wbRef.actionSet.actionAbout );
		add( menu_help );
	}
}
