import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.print.*;
import java.util.*;

public class NekjeDocumentPainter extends JComponent implements Printable {
    		
    	protected Document doc;
    	protected PageFormat pFormat;
    	protected ArrayList pages;
    	protected Font font;
    	protected boolean rowNumbers;	
    	
    	private int currentPage;
    	private Dimension mPreferredSize;
    		
    	public NekjeDocumentPainter( Document d, PageFormat pf, boolean rowNumbers ) {
    		super();
    		doc = d;
    		pFormat = pf;
    		this.rowNumbers = rowNumbers;
    		
       		font = new Font("Monospaced", Font.PLAIN, 10);
   		
    		pages = repaginate(pf);
    		
    		
    	}
      	
      	public Dimension getPreferredSize() { return mPreferredSize; }
  	
    	public int calculatePageCount() {
    		
    		if( pages == null )
    			pages = repaginate( pFormat );
    		return pages.size();
    	}
    	
    		
    	public ArrayList repaginate( PageFormat pf ) {
    		
    		int maxh = (int)pf.getImageableHeight();
    		int lineh = font.getSize();
    		
    		Element root = doc.getDefaultRootElement();
    		int elemNum = root.getElementCount();
    		
    		
    		ArrayList pgs = new ArrayList();
    		
    		int pageh = 0;
    		ArrayList page = new ArrayList();
    		
    		for( int i=0; i < elemNum; i++ ) {
    		
    			Element line = root.getElement(i);
    			
    			try {
    			 	CodeLine cl = new CodeLine( 
    			 		doc.getText(line.getStartOffset(), 
    						line.getEndOffset()-line.getStartOffset() ), i+1 );
    					
    				if( pageh + lineh > maxh ) {
    			
    					pgs.add( page );
    					page = new ArrayList();
    					pageh= 0;
    				}
    				page.add( cl );
    				pageh += lineh;    						
    			}
    			catch( BadLocationException e) {
    				break;		
    			}
   			}
    		
    		// Fuegt die letzte Seite ein
    		pgs.add(page);
    		
    		return( pgs ); 
    	}
    	
  	public int print(Graphics g, PageFormat pf, int pageIndex) 
  						throws PrinterException {
         if( pFormat != pf ) {
			pFormat = pf;
			pages = repaginate( pf );
		}
        	
	if( pageIndex >= pages.size() )
			return Printable.NO_SUCH_PAGE;
			    
	currentPage = pageIndex;
		 		
      	Graphics2D g2 = (Graphics2D) g;
    	g2.translate(pf.getImageableX(), pf.getImageableY());		
    	mPreferredSize = new Dimension((int)pf.getImageableWidth(),
        	(int)pf.getImageableHeight());				
		//System.out.println("Seite " + pageIndex);
		paintComponent( g2 );
		
		return Printable.PAGE_EXISTS;
      	}
      		

	public void paintComponent( Graphics g ) {
		
		Graphics2D g2 = (Graphics2D) g;
		FontMetrics fm = g.getFontMetrics();
		
		int numwidth = fm.stringWidth("00000: ");
		
        	int y = font.getSize();
	    	// Make the background white.
    		java.awt.geom.Rectangle2D r = new java.awt.geom.Rectangle2D.Float(0, 0,
      		mPreferredSize.width, mPreferredSize.height);
    		g2.setPaint(Color.white);
    		g2.fill(r);
        	
        	ArrayList page = (ArrayList)pages.get(currentPage);
        	Iterator it = page.iterator();
        	
        	g2.setPaint(Color.black);
      		g2.setFont( font );

        	while( it.hasNext() ) {

	        	int x = 0;

        		CodeLine cl = (CodeLine)it.next();

                   // An dieser Stelle erfolgt eine Neuformatierung des Strings.
               		String tmpstr = trimLine( cl.getLine() );
        		
			if( rowNumbers == true ) {
				g2.drawString( cl.getNumLine() + ":", x, y);
				x = numwidth+ 10;					
			}
	
         		g2.drawString( tmpstr, x, y);
				y += font.getSize();
       		}	
	}
	
       private String trimLine( String inline ) {

               StringBuffer temp = new StringBuffer();
               
               int i = 0;
               int pos = 0;
               
               for( ; i < inline.length(); i++) {

                    // Ersetze Tabulatoren durch Leerzeichen
                    if( inline.charAt(i) == '\t' ) {
                        if( i > pos )  {
                            temp.append( inline.substring(pos,i));
                        }
                        temp.append("    ");
                        pos = i+1;
                    }
               }
                
               if( i > pos ) {
                    temp.append( inline.substring(pos,i) );
               }
                
               // Schneidet rechten Rand ab
               for( i = temp.length()-1; i >= 0 && temp.charAt(i) < ' '; i-- ) {
                    ;
               }

               return temp.substring(0,i+1);
       }
       
	class CodeLine {
	
		private String line;
		private int numLine;
		
		public CodeLine( String line, int numLine ) {
			this.line = line;
			this.numLine = numLine;
		}
		
		public String getLine() { return line; }
		public int getNumLine() { return numLine; }
		
	}
}
			
