import java.util.*;
import javax.swing.text.*;

public class NekjeDocument extends SyntaxDocument {
	public NekjeDocument() {
	}	
	
	/**
	*	Filtert den Namen der im Dokument enthaltenen Klasse heraus.
	*	(Unbedingt ueberarbeiten :-( , uebler Hack)
	*	--- zur Zeit ersetzt durch Methode in NekjeScrollEditor ---
	*/
	public String getClassName() {

		String className = "";
		ElementIterator eIt = new ElementIterator( this );
		Element cElement = null;

		boolean found = false;
		
		for( cElement = eIt.first(); 
			cElement != null && (found == false || className.length() < 1); 
			cElement = eIt.next() ) {

			int start = cElement.getStartOffset();
			int end = cElement.getEndOffset();
			
			try{
				StringTokenizer sTokens = new StringTokenizer( getText( start, end-start ),
					" {}\t\n\r\f" );

				while( sTokens.hasMoreTokens() ) {
					String str = sTokens.nextToken();

					if( found == true )	{
						className = str;
						break;
					}

					if( str.equals("class") || str.equals("interface") )
						found = true;				
				}
			}

			catch( BadLocationException e ) {
				 break; 
			}
		}

		return( className );
	}

    /**
    *	Ermittelt den Texttoken an der aktuellen Dokumentposition
    */
    public String getCurrentToken( int offset ) {
        	
        int rowStart = getRowStart( offset );
        int rowEnd = getRowEnd( offset );
        String memToken="";
        String currentToken = "";
        int currentPos = 0;
        int searchPos = offset-rowStart;
        	
        try {
          	String temp = getText( rowStart, rowEnd-rowStart );
      	
        	StringTokenizer st = 
        	new StringTokenizer(temp, " ;,.(){}[]=<>!%\"\t\n\r\f");
        	
			while (st.hasMoreTokens()) {

				currentToken = st.nextToken();
     		
     			currentPos = temp.indexOf( currentToken, currentPos );

     			if( currentPos > searchPos )
     				break;
     					
     			memToken = currentToken;	
     		}
     	}
     	catch( BadLocationException e ) {
     		memToken = "";
     	}
     		
     	return( memToken );
	}
	
	/**
	*	Gibt die Startposition der aktuellen Zeile im Dokument zurueck
	*/
	public int getRowStart( int offset ) {		
		return( getParagraphElement( offset).getStartOffset() );
	}
	
	/**
	*	Gibt die Endposition der aktuellen Zeile im Dokument zurueck
	*/
	public int getRowEnd( int offset ) {		
		return( getParagraphElement( offset).getEndOffset() );
	}

	public int insertParagraph( int offset ) {

		String indent = getRowIndent( getRowStart(offset), offset );

		String lb = "\n";
		int ilen = indent.length();

		try {
			insertString( offset, "{" + lb + indent + "\t" + lb + indent + "}", null );
			return( offset + ilen + 3 );
		}

		catch( BadLocationException e ) {
		}

		return( offset );
	}

	public int insertBlock( String text, int offset, int newpos ) {

		int position = 0;
		int maxpos = newpos;
//		String lb = "\n";

		StringTokenizer stok = new StringTokenizer( text, "\n", true);

		// Holt Einzug der aktuellen Zeile
		String indent = getRowIndent( getRowStart(offset), offset );
		int ilen = indent.length();

   		String newtext = "";

		while( stok.hasMoreTokens() ) {

			String temp = stok.nextToken()/* + lb */;
			int len = temp.length();
			newtext += temp;

			if( maxpos > 0 ) {
				if( maxpos - len >= 0 ) {
					position += len;
					maxpos -= len;
				}
				else {
					position += maxpos;
					maxpos = -1;
				}
			}
			
			if( temp.endsWith("\n") ) {
				newtext += indent;
				if( maxpos >= 0 )
					position += indent.length();
			}

			if( maxpos == 0) 
				maxpos = -1;
		}

		try {
			insertString( offset, newtext, null );
		}
		catch( BadLocationException e ) {}

		return( offset+position );
	}

	public void insertString(int offset, String str, AttributeSet a)
           throws BadLocationException {

	    	int start;
        	String lb = "\n";

        	if( str.equals( lb ) ) {
	        	start = getRowStart( offset );

	        	if( start < offset ) {
        	   		if( lb != null ) str = lb;
       				str += getRowIndent( start, offset  );
	       		}
       		}
       		else if( str.equals("{") ) {
			start = getRowStart( offset );

    			if( start < offset ) {
   		   		str += lb +"\t" + getRowIndent( start, offset  );
    			}
      		}
       		else if( str.equals("}") ) {
       			int tstart = getRowStart(offset);
       			String temp = getText( tstart, offset-tstart ) ;
       			String prev = getPreviousIndent( offset);

      			if( isWhitespaceString( temp ) ){
				if( temp != null && temp.length() > 0 ) {
					remove( tstart, offset-tstart);
					offset = tstart;
				}
				str = prev + "}" + lb + prev;	
			}
       			else {        		
       				str = lb + prev + "}" + lb + prev;
       			}
       		}
		super.insertString( offset, str, a );                
	}

	public boolean isWhitespaceString( String str ) {

		for( int i = 0; i < str.length(); i++ ) {
			if( Character.isWhitespace( str.charAt(i) ) == false )
				return( false );
		}

		return( true );		
	}

	public String getPreviousIndent(int offset) {

		Element cElement = getDefaultRootElement();
		int cIndex = cElement.getElementIndex( offset );

		int ebene = 0;

		for(int i = cIndex; i >= 0; i--) {
			Element tElement = cElement.getElement( i );
			int start = tElement.getStartOffset();
			int end = tElement.getEndOffset();

			try{
				String elemString = getText( start, end-start );
				if( elemString.indexOf( (int)'{') >= 0 ) {
					if( ebene <= 0 )
						return( getRowIndent(tElement.getStartOffset(), 
						tElement.getEndOffset()) );
					else
						ebene--;	
				}
				else if( elemString.indexOf( (int)'}') >= 0 ) {
					ebene++;
				}	
			}
			catch( BadLocationException e ) { 
				break; 
			}
		}
		return("");
	}

	/**
	*	Liefert als String den Beginn der aktuellen Zeile, wenn Einzug vorliegt
	*/
	public String getRowIndent( int start, int offset ) {

		String elemString = null;
		int charPos = 0;

		try {
			elemString = getText(start, offset-start);

			for( ; charPos < (offset-start) &&
					(elemString.charAt(charPos) == '\t' ||
					elemString.charAt(charPos) == ' ' ); charPos++ ) ;
		}
		catch( BadLocationException e ) {
			charPos = 0;
		}
		return( elemString.substring( 0, charPos ) );
	}
}
																										