import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.print.*;
import java.text.*;
import java.io.*;
import java.util.*;

import gnu.regexp.*;

public class NekjeConsole extends JFrame implements ActionListener {
    protected JTextArea textArea;
    protected Font textFont;
    protected Font font;
    protected Nekje pp;
    protected Document doc;

    protected String classpath = ".";
    protected String warning = "";
    
	private RE re=null; // RegularExpression fuer getClassName()
	private final String searchString = "\\w+\\.\\w+:\\d+:";

    public NekjeConsole( Nekje parent ) {

        super("Nekje Console");
        pp = parent;

        getContentPane().setLayout( new BorderLayout() );

        textArea = new JTextArea();
        textArea.setLineWrap( false );
        textFont = new Font("Monospaced", Font.PLAIN, 12 );
        textArea.setFont( textFont );
        textArea.setEditable(false);
        doc = textArea.getDocument();

        JScrollPane scrollPane = new JScrollPane( textArea );

        JPanel buttonPanel = new JPanel();

        JButton closeButton = new JButton("Schlieen");
        closeButton.setActionCommand("Close");
        closeButton.addActionListener( this );

        JButton printButton = new JButton("Drucken");
        printButton.setActionCommand("Print");
        printButton.addActionListener( this);

        JButton gotoButton = new JButton("Gehe zu");
        gotoButton.setActionCommand("Goto");
        gotoButton.addActionListener( this);

        buttonPanel.add(closeButton );
        buttonPanel.add(printButton );

	buttonPanel.add(gotoButton );

        getContentPane().add( scrollPane, BorderLayout.CENTER);
        getContentPane().add( buttonPanel, BorderLayout.SOUTH);

        addWindowListener(
        	new WindowAdapter() {
            		public void windowClosing(WindowEvent e) {
                		setVisible(false);
            		}
        	}
        );

	try {
		re = new RE( searchString );
	}
	catch( Exception e ) {
		re = null;
	}	

	try {
		setSize( Integer.parseInt( pp.getProperties().getProperty("nekjeConsoleWidth") ),
        		Integer.parseInt( pp.getProperties().getProperty("nekjeConsoleHeight") ) );
        	setLocation( Integer.parseInt( pp.getProperties().getProperty("nekjeConsoleX") ),
        		Integer.parseInt( pp.getProperties().getProperty("nekjeConsoleY") ) );
	}
	catch( Exception e ) {
		setSize( 600, 400 );
		setLocation(pp.getX()+50,pp.getY()+100);
	}
	
        setVisible(false);
    }

    public void actionPerformed( ActionEvent e ) {

        String command = e.getActionCommand();
	
        if( command.equals("Print") ) {
            this.printConsoleText();
        }
        else if( command.equals("Close") ) {
            this.setVisible(false);
        }
        else if( command.equals("Goto") ) {
        	try {
	        	
			String tstr = textArea.getSelectedText();
			REMatch match = re.getMatch( tstr );

			if( match != null ) {
				String matchStr = match.toString();
				int pos = matchStr.indexOf(':');

				String fname = matchStr.substring(0,pos);
				String line = matchStr.substring(pos+1, (matchStr.length()-1) );
			
				try {
				
					if( pp.getWBPanel().activateTab( fname ) == true ){
						pp.getWBPanel().gotoLine( Integer.parseInt( line ) - 1 );
						System.err.println("Editor gefunden");
					}
				}
				catch( Exception ex ){
					// ignore
				}
			}
		}
		catch( Exception ex2 ) {
			// ignore
		}
        }
    }

    public void processSystemCommand( final String command ) {
        Thread runner = new Thread() {
            public void run() {
                try {
                    Process p = Runtime.getRuntime().exec(
                    "c:\\windows\\command.com " + command);
                }
                catch( IOException e ) {
                }
            }
        };

        runner.start();
    }

    public void processCommand( final String command ) {
        Thread runner = new Thread() {
            public void run() {
                textArea.setText("");
                setVisible(true);
                textArea.append( warning );
                textArea.append("[BEFEHL:] " + command + "\n\n");

                String text="";

                try {
                    Process p = Runtime.getRuntime().exec(command);

                    BufferedReader in1 = new BufferedReader(
                    new InputStreamReader( p.getErrorStream() ) );


                    // Ausgabe von STDERR
                    boolean err = false;
                    textArea.append("[FEHLER:] ");

                    while( ( text = in1.readLine() ) != null ) {
                        if( err == false )
                        err = true;
                        textArea.append( "\n\t" + text );
                    }

                    if( err == false ) {
                        textArea.append("Keine Fehler gefunden.\n");
                    }

                    in1.close();


                    // Ausgabe von STDOUT
                    textArea.append("\n[STDOUT:]\n");

                    BufferedReader in2 = new BufferedReader(
                    new InputStreamReader( p.getInputStream() ) );

                    int i = 0;
                    while( ( text = in2.readLine() ) != null && i < 4) {
                        textArea.append( "\t" + text +"\n" );

                    }
                    in2.close();

                    textArea.append( "\n[EXIT-WERT:] " + p.exitValue() +
                    "\n");
                }
                catch( IOException ex ) {
                    textArea.append( ex.toString() );
                }
            }
        };

        runner.start();
    }

    synchronized void printConsoleText() {

        // Get a PrinterJob
        final PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf = job.defaultPage();

        Book bk = new Book();
        NekjeDocumentPainter dp = new NekjeDocumentPainter( doc, pf,
        false );
        int pnum = dp.calculatePageCount();
        bk.append( dp, pf, pnum );

        // Pass the book to the PrinterJob
        job.setPageable( bk );

        // Put up the dialog box
        if (job.printDialog()) {
            Thread runner = new Thread() {
                public void run() {

                    // Print the job if the user didn't cancel printing
                    try { job.print(); }
                    catch (Exception exc) { /* Handle Exception */ }
                }
            };
            runner.start();
        }
    }


    public void compileJavaApp( String jDir, String oDir, String jFile ) {

        String cp = "";
        String outp = "";
        String pcp = pp.getProperties().getProperty("classpath");
        String pathSep = pp.getProperties().getProperty("pathSeparator");
        String outputPath = pp.getProperties().getProperty(
        "outputDirectory");

        warning = "";

        if( pathSep == null ) {
            // Setze Default
            pathSep = ";";
        }

        if( pcp != null && pcp.length() > 0 )
        cp = pcp + pathSep + jDir;
        else
        cp = jDir;

        if( outputPath != null && outputPath.length() > 0 )
        outp = outputPath;
        else
        outp = oDir;

        processCommand( pp.getProperties().getProperty("javacExe") +
        " -classpath " + cp + " -d " + outp + " " + jDir+jFile );
    }

    /**
    * Ruft den Java-Interpreter auf
    */
    public void runJavaApp( String clDir, String clFile,
    String clParameter,
    boolean systemFlag ) {

        // Pruefe, ob Standardsuffix .java oder .class vorhanden.
        // Bei Standardsuffix schneide Suffix ab, sonst lasse den
        // Dateinamen unveraendert und riskiere Fehlermeldung von
        // Java
        String str = clFile;
        String workingDir = clDir;
        String cp = clDir;
        String pcp = pp.getProperties().getProperty("classpath");
        String pathSep = pp.getProperties().getProperty("pathSeparator");
        String outputPath = pp.getProperties().getProperty(
        "outputDirectory");
        warning =
        "Hinweis: Umfangreiche DOS-Konsolenausgaben fuehren unter Windows 95/98\nleider zum Haengen von Prozessen (siehe hierzu Nekje-Hilfe)\n\n"
        ;

        if( pathSep == null ) {
            // Setzte Default
            pathSep = ";";
        }

        // Muessen beim classpath Ergaenzungen vorgenommen werden?
        if( pcp != null && pcp.length() > 0 )
        cp = pcp + pathSep + clDir;
        else
        cp = clDir;

        if( outputPath != null &&
        outputPath.equals( clDir ) == false ){
            cp += pathSep+outputPath;
        }

        // Wenn Applikation, rufe JVM auf.
        if( str.endsWith(".java") || str.endsWith(".class") ) {

            str = str.substring(0, str.lastIndexOf('.') );

            // Anhaengen von evtl. Kommandozeilen-Parametern
            if( clParameter != null )
            str += " " + clParameter;

            String cmd = pp.getProperties().getProperty("javaExe") +
            " -classpath " + cp + " " + str;
            if( systemFlag == false ) {
                // Uebergebe String an Nekje-Shell
                processCommand( cmd );
            }
            else {
                // Uebergeb an System-Shell
                processSystemCommand( cmd );
            }
        }
        // Wenn HTML mit Applet, starte Appletviewer
        else if( str.endsWith(".htm") || str.endsWith(".html") ) {
            // Anhaengen von evtl. Kommandozeilen-Parametern
            if( clParameter != null )
            str += " " + clParameter;

            System.setProperty("user.dir", workingDir);
            processCommand( pp.getProperties().getProperty(
            "appletviewerExe")
            + " file:///" + workingDir + str );

        }
    }

    public void showDocument( final Document doc ) {

        final Element elem = doc.getDefaultRootElement();

        final int elemCount = elem.getElementCount();

        Thread runner = new Thread() {
            public void run() {

                int start, end;
                textArea.setText("");
                setVisible(true);
                for(int i = 0; i < elemCount; i++ ) {
                    Element cElem = elem.getElement(i);
                    start = cElem.getStartOffset();
                    end = cElem.getEndOffset();

                    textArea.append("\nElement (" + start +" " + end +
                    ") " + i + ": ");
                    try {
                        int len = end-start;
                        String cText = doc.getText( start,len);
                        textArea.append(cText);
                    }
                    catch(BadLocationException ex) {}
                }

                if( pp.getProperties() != null ) {
                    String str = pp.getProperties().getProperty("javaExe"
                        );

                    textArea.append("Property javaExe = " + str + "\n");
                }
                else {
                    textArea.append("Sorry. Keine Properties gefunden.\n"
                    );
                }

            }
        };

        runner.start();
    }

    public void setErrorColor() {
        textArea.setForeground( Color.red);
    }

    public void setStandardColor() {
        textArea.setForeground( Color.black );
    }

    public void appendText( String text ) {
        textArea.append( text );
    }
}

