import java.util.*;
import java.net.*;
import java.io.*;

public class NekjeCodeSnippets {
	private Vector vSnippets = null;

	public NekjeCodeSnippets( String inFile ) {
		loadCodeSnippets( inFile );
	}

	public void loadCodeSnippets( String inFile ) {

		if( inFile != null && inFile.length() > 0 ) {
			BufferedReader in = null;
			try {
				URL src = new URL( inFile );
				in = new BufferedReader( new InputStreamReader( (InputStream)src.getContent() ) );
			}
			catch( Exception e ) {
				try {
					in = new BufferedReader( new FileReader( inFile ) );
				}
				catch(Exception ex){
					System.err.println(ex.toString());
				}
			}

			if( in != null ) {
				String temp;
				String key = null;
				String value = "";

				vSnippets = new Vector();

				try {
					while( (temp = in.readLine()) != null ) {
						if( temp.startsWith("[") ) {
							if( key != null ) {
								vSnippets.addElement( new CodeSnippet( key, value ) );
								key = null;
								value = "";
							}

							if( key == null ) {
								key = temp.substring(1, 
									temp.indexOf(']'));	
							}								
						}
						else {
							value += temp + "\n";
						}						
					}
				}
				catch( IOException e ){
					// Fehler beim Einlesen der Datei
				}

				if( key != null ) {
					vSnippets.addElement( new CodeSnippet(key, value) );
				}

				try {
					in.close();
				}
				catch( IOException ex ){}
			}
		}
	}

	public String getCode( String key ) {
		if( vSnippets != null ) {
			for (Enumeration e = vSnippets.elements() ; e.hasMoreElements() ;) {
				CodeSnippet snippet = (CodeSnippet)e.nextElement();

				if( key.equals(snippet.getKey()) )
					return( snippet.getValue() );
			}
		}
		return("");
	}
	
	public int size(){
		return vSnippets.size();
	}

	public String getKeyAt( int idx ) {
		CodeSnippet temp = (CodeSnippet)vSnippets.elementAt( idx );
		if( temp != null ){
			return temp.getKey();
		}
		return null;
	}
}

/**
*	Einzelnes Quelltext-Schnipsel
*/
class CodeSnippet {
	protected String key;
	protected String value;
	protected int position;
	
	// Konstruktor
	public CodeSnippet( String key, String value ) {
		this.key = key;
		this.value = value;
		position = 0;
	}
	
	public String getKey() {
		return( this.key );
	}
	
	public String getValue() {
		return( this.value );
	}
		
}