/*
* Modifiziert nach http://manning.spindoczine.com/sbe/files/uts2/Chapter12html/Chapter12.htm
*/   

import java.awt.*;
import javax.swing.*;

/**
*	Kleine Schaltknpfe fr NekjeToolbar
*/
public class NekjeButton extends JButton {
	
	public NekjeButton( Action act, ImageIcon icon, String tip ) {
		super( icon );
		setValues( act,tip );
	}
		
	public NekjeButton( Action act, String tip ) {
		this( act, (ImageIcon)act.getValue(Action.SMALL_ICON), tip );
	}
	
	public NekjeButton( Action act ) {
		this( act, (ImageIcon)act.getValue(Action.SMALL_ICON),
			 ( String )act.getValue( Action.SHORT_DESCRIPTION ) );
	}
	
	public void setValues( Action act, String tip) {
		
		setMargin( new Insets(1,1,1,1) );
		setToolTipText( tip );
		addActionListener( act );
		setRequestFocusEnabled( false );
		
	}	
}