import java.awt.event.*;

public class NekjeActionViewDoc extends NekjeAction {
	
	public NekjeActionViewDoc( NekjeWBPanel wbRef ) {
		super( wbRef );
		putValues("Online-Dokumentation", null, "Hilfe");
	}

	public void actionPerformed(ActionEvent e) {
		String docUrl = wbRef.getProperties().getProperty("docURL");
		
		// Normalisierungsversuch fuer Windowssysteme
		if( docUrl.indexOf("://") < 0 
			&& docUrl.indexOf(":") < 0 
			&& System.getProperty("file.separator").equals("\\") ){
			// vermutlich wurde ein relativer Pfad auf einem WindowsSystem angegeben
			docUrl = "file:///"+System.getProperty("user.dir") + "\\" + docUrl;				
		}
		
		String temp = wbRef.getProperties().getProperty("browserExe") + " " +docUrl;
		wbRef.processCommand( temp );
	}
}
