/**
* Klasse NekjeActionSet definiert alle Handlungen, die vom Menue und von der
* Tool-Leiste ausgefuehrt werden koennen.
*/
import javax.swing.*;

public class NekjeActionSet {
	
	private NekjeWBPanel wbRef;
	
	public NekjeAction actionNew;	
	public NekjeAction actionOpen;
	public NekjeAction actionResave;
	public NekjeAction actionSaveAs;
	public NekjeAction actionPrint;
	public NekjeAction actionClose;
	public NekjeAction actionExit;
	
	public NekjeAction actionCut;
	public NekjeAction actionCopy;
	public NekjeAction actionPaste;
	public NekjeAction actionDelete;
	public NekjeAction actionDuplicateCode;
	public NekjeAction actionSelectAll;
	public NekjeAction actionUndo;
	public NekjeAction actionRedo;
		
	public NekjeAction actionCompile;
	public NekjeAction actionRun;
	public NekjeAction actionRunParam;
	public NekjeAction actionIndent;
	
	public NekjeAction actionHTML;
	public NekjeAction actionComment;
	
	public NekjeAction actionCodeSnippet;
	public NekjeAction actionReference;
	public NekjeAction actionViewDoc;
	public NekjeAction actionAbout;
	
	
	public NekjeActionSet( NekjeWBPanel wbRef ) {
		this.wbRef = wbRef;
		
		actionNew = new NekjeActionNew( wbRef );
		actionOpen = new NekjeActionOpen( wbRef );
		actionClose = new NekjeActionClose( wbRef );
		actionResave = new NekjeActionResave( wbRef );
		actionSaveAs = new NekjeActionSaveAs( wbRef );
                actionPrint = new NekjeActionPrint( wbRef );
		actionExit = new NekjeActionExit( wbRef );

		actionCut = new NekjeActionCut( wbRef );
		actionCopy = new NekjeActionCopy( wbRef );
		actionPaste = new NekjeActionPaste( wbRef );
		actionDelete = new NekjeActionDelete( wbRef );
		actionDuplicateCode = new NekjeActionDuplicateCode( wbRef );
		actionUndo = new NekjeActionUndo( wbRef );
		actionRedo = new NekjeActionRedo( wbRef );
		actionSelectAll = new NekjeActionSelectAll( wbRef );
		
		if( wbRef.getProperties().getProperty("javacExe") != null ) {
			actionCompile = new NekjeActionCompile( wbRef );
		}
		
		if( wbRef.getProperties().getProperty("javaExe") != null ) {
			actionRun = new NekjeActionRun( wbRef );
			actionRunParam = new NekjeActionRunParam( wbRef );
		}

		if( wbRef.getIndentPlugin() != null ) {
			actionIndent = new NekjeActionIndent( wbRef );
		}
		
		if( wbRef.getProperties().getProperty("appletviewerExe") != null ) {
			actionHTML = new NekjeActionHTML( wbRef );
		}
		
		actionComment = new NekjeActionComment( wbRef );
		
		
		if( wbRef.getApplication().getCodeSnippets() != null )
			actionCodeSnippet = new NekjeActionCodeSnippet( wbRef );
		if( wbRef.getReferenceBrowser() != null )
			actionReference = new NekjeActionReference( wbRef );

		actionViewDoc = new NekjeActionViewDoc( wbRef );

		actionAbout = new NekjeActionAbout( wbRef );
	}	
}
										
