import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.print.*;

public class NekjeActionPrint extends NekjeAction {

	public NekjeActionPrint( NekjeWBPanel wbRef ) {
		super( wbRef );
		putValues("Drucken...", "file_print.gif", "Aktueller Quelltext wird ausgedruckt.");
		setAccelerator( KeyEvent.VK_P, Event.CTRL_MASK );
	}

	public void actionPerformed(ActionEvent e) {

		if( wbRef.hasTab() ) {
                     printEditorText();
		}
	}
 
        /**
        *  Methode druckt den aktuellen Quelltext
        */
        protected void printEditorText() {

		final Document doc = wbRef.getCurrentDocument();

		// Get a PrinterJob
    		final PrinterJob job = PrinterJob.getPrinterJob();
    		// Create a landscape page format
    		PageFormat pf = job.defaultPage();

 		Book bk = new Book();
   		NekjeDocumentPainter dp = new NekjeDocumentPainter( doc, pf, true );
   		int pnum = dp.calculatePageCount();
       		bk.append( dp, pf, pnum );

    		// Pass the book to the PrinterJob
    		job.setPageable( bk );


		// Put up the dialog box
		if (job.printDialog()) {
       			// Print the job if the user didn't cancel printing
      			Thread runner = new Thread() {

      				public void run() {
      					try { job.print(); }
      					catch (Exception exc) {}
      					}
    			};

    			runner.start();
		}
    }
}

