import javax.swing.*;
import javax.swing.event.*;

import java.awt.*;

public abstract class NekjeAction extends AbstractAction {
	 	
	protected NekjeWBPanel wbRef;
	protected KeyStroke accelerator;
	
	public NekjeAction( NekjeWBPanel wbRef ) {
	
		this.wbRef = wbRef;
		this.accelerator = null;
	}
	
	public void putValues( String str1, String str2, String str3 ) {
		if( str1 != null ) putValue(Action.NAME,str1);
		if( str2 != null ) putValue(Action.SMALL_ICON, new ImageIcon( getClass().getResource("images/"+str2) ) );
		if( str3 != null ) putValue(Action.SHORT_DESCRIPTION, str3 );
	}	
	
	public void setAccelerator( int keyCode, int modifiers ) {
		accelerator = KeyStroke.getKeyStroke( keyCode, modifiers );
	}
	
	public KeyStroke getAccelerator() {
		return accelerator;
	}
}
		