/*
*
* NEKJE - Nur ein kleiner Java-Editor
*
* Voellig ueberarbeitete Version Sommer 2001
* unter Benutzung von JEdit-Komponenten
*/
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.net.*;
import java.io.*;

public class Nekje extends JFrame {

    /**
    * Referenz auf das Workingbench-Panel
    */
    protected NekjeWBPanel wbPanel;

    /**
    * Referenz auf das Menue-Panel
    */
    protected NekjeMenuBar nekjeMenuBar;

    /**
    * Referenz auf die Toolbar
    */
    protected NekjeToolBar nekjeToolBar;

    protected NekjeConsole nekjeConsole;

    protected NekjeCodeSnippets nekjeCodeSnippets;

    protected NekjeReference nekjeReference;

    public Properties props;

    private final String version = "Nekje Version 020709";

    /**
    *	Konstruktor
    */
    public Nekje( String properties ) {
        super( "Nekje" );
        SplashScreen sscreen = new SplashScreen( "images/nekje.png" );
        sscreen.setVisible(true);

        sscreen.setText( version, 5 );

        sscreen.setText( "Lade Look-And-Feel", 20 );
        setLookAndFeel();
        setAppIcon();

        sscreen.setText( "Lade Eigenschaften", 35 );
        props = initProperties( properties );

        sscreen.setText( "Lade Referenz-Browser", 50 );
        initReferenceBrowser();

        sscreen.setText( "Lade Quelltext-Bausteine", 70 );
        initCodeSnippets();

        sscreen.setText( "Lade GUI-Elemente", 90 );
        nekjeConsole = new NekjeConsole( this );

        // Elemente der Benutzeroberflaeche werden erzeugt
        wbPanel = new NekjeWBPanel( this );
        nekjeMenuBar = new NekjeMenuBar( wbPanel );
        nekjeToolBar = new NekjeToolBar( wbPanel );


        // Elemente der Benutzeroberflaeche werden mit Programmfenster verbunden
        setJMenuBar( nekjeMenuBar );
        getContentPane().setLayout( new BorderLayout() );
        getContentPane().add( nekjeToolBar, BorderLayout.NORTH);
        getContentPane().add( wbPanel, BorderLayout.CENTER);

        // WindowListener fuer Button "Programmfenster schliessen" wird erzeugt
        // und mit Programmfenster verbunden
        addWindowListener(
        new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                wbPanel.actionSet.actionExit.actionPerformed(null);
            }
        }
        );

        sscreen.setVisible(false);
        sscreen.dispose();
    }

    /**
    * Initialisert die integrierte Kontext-Hilfe
    */
    protected void initReferenceBrowser() {

        String rData = getProperties().getProperty("referenceData");

        if( rData != null ) {
            nekjeReference = new NekjeReference();
            nekjeReference.setParent( this );
            try {
                int width = Integer.parseInt( props.getProperty(
                    "nekjeReferenceWidth") );
                int height = Integer.parseInt( props.getProperty(
                    "nekjeReferenceHeight") );
                int xPos = Integer.parseInt( props.getProperty(
                    "nekjeReferenceX") );
                int yPos = Integer.parseInt( props.getProperty(
                    "nekjeReferenceY") );
                nekjeReference.setSize( width, height );
                nekjeReference.setLocation( xPos, yPos );
            }
            catch( Exception e ) {
                nekjeReference.setSize(400,400);
                nekjeReference.setLocation(0,0);
            }
            nekjeReference.setReferenceSource( rData );
            nekjeReference.setClassPath( System.getProperty(
                "java.class.path") );
        }
    }

    public String getVersion() {
        return version;
    }

    public NekjeReference getReferenceBrowser() {
        return nekjeReference;
    }

    public void initCodeSnippets() {
        String sData = getProperties().getProperty("codeSnippets");

        if( sData != null ) {
            nekjeCodeSnippets = new NekjeCodeSnippets( sData );
        }
    }

    public NekjeCodeSnippets getCodeSnippets() {
        return nekjeCodeSnippets;
    }

    public NekjeConsole getConsole() {
        return nekjeConsole;
    }

    public NekjeWBPanel getWBPanel() {
        return wbPanel;
    }

    /**
    *	Setzt Look-and-Feel fuer die Applikation aufgrund der Eigenschaft "plaf".
    *	Die Eigenschaft kann in der Eigenschaftsdatei extern festgelegt werden.
    * 	Erfolgt keine Festlegung, so wird versucht den Layout-Standard des benutzten
    *	Systems zu ermitteln.
    */
    private void setLookAndFeel() {

        String plaf = null;

        if( props != null ) {
            plaf = props.getProperty("plaf");
        }

        if( plaf == null ) {
            plaf = UIManager.getSystemLookAndFeelClassName();
        }

        if( plaf != null ) {

            try {
                UIManager.setLookAndFeel( plaf );
            }
            catch( InstantiationException e ){
            }
            catch( ClassNotFoundException e ){
            }
            catch( UnsupportedLookAndFeelException e ){
            }
            catch( IllegalAccessException e ){
            }
        }
    }

    /**
    *	Setzt den programmeigenen Symbol-Icon
    */
    private void setAppIcon() {
        ImageIcon nekjeIcon = new ImageIcon(getClass().getResource(
            "images/nekje_icon.gif"));
        setIconImage( nekjeIcon.getImage() );
    }

    private Properties initProperties( String pr ) {

        Properties tprops = new Properties();

        setDefaultProperties( tprops );
        loadProperties( tprops, pr );

        setSystemClassPath(tprops);

        return( tprops );
    }

    private void setSystemClassPath( Properties tprops ) {
        String cp = tprops.getProperty( "classpath" );
        String wd = tprops.getProperty( "workingDirectory" );
        String od = tprops.getProperty( "outputDirectory" );

        String ps = tprops.getProperty( "pathSeparator" );
        String sp = System.getProperty( "java.class.path");

        if( cp != null && cp.length() > 0 ) {
            StringTokenizer st = new StringTokenizer( cp, ps);

            while( st.hasMoreTokens() ) {
                String temp = st.nextToken();
                if( sp.indexOf(temp) == -1 )
                sp = temp+ps+sp;
            }
        }

        /*
        if( wd != null && wd.length() > 0 && sp.indexOf( wd ) == -1 )
        sp += ps + wd;
        if( od != null && od.length() > 0 && sp.indexOf( od ) == -1 )
        sp += ps + od;
        */

        if( sp.equals( System.getProperty("java.class.path") ) == false )
        System.setProperty("java.class.path", sp );
    }

    private void setDefaultProperties( Properties pr ) {

        pr.setProperty("pathSeparator", System.getProperty(
            "path.separator") );
        pr.setProperty("lineBreak", System.getProperty("line.separator"
            ) );
        pr.setProperty("workingDirectory", System.getProperty("user.dir"
            ) );
        pr.setProperty("outputDirectory", "");
        pr.setProperty("classpath", "");
        pr.setProperty("nekjeFont", "Monospaced");
        pr.setProperty("nekjeFontsize", "14");
        pr.setProperty("nekjeFonttype", "BOLD");

        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        pr.setProperty("nekjeScreenWidth", ""+(int)dim.getWidth() );
        pr.setProperty("nekjeScreenHeight", ""+((int)(dim.getHeight
            ()*7/10)-35) );
        pr.setProperty("nekjeScreenX", "0" );
        pr.setProperty("nekjeScreenY", "0" );
        pr.setProperty("nekjeConsoleWidth", ""+(int)dim.getWidth() );
        pr.setProperty("nekjeConsoleHeight", ""+((int)(dim.getHeight
            ()*3/10)) );
        pr.setProperty("nekjeConsoleX", "0" );
        pr.setProperty("nekjeConsoleY", ""+((int)(dim.getHeight
            ()*7/10)-35) );
        pr.setProperty("nekjeReferenceWidth", ""+(int)(dim.getWidth
            ()*4/10) );
        pr.setProperty("nekjeReferenceHeight", ""+((int)(dim.getHeight
            ()*7/10)-40) );
        pr.setProperty("nekjeReferenceX", ""+(int)( dim.getWidth() -
            (dim.getWidth()*4/10)));
        pr.setProperty("nekjeReferenceY", "40" );
    }

    public void loadProperties( Properties pr, String resrc ) {
        try {
            URL src = new URL( resrc );
            pr.load( (InputStream)src.getContent() );
        }
        catch( Exception e ) {
            // Problem beim Laden der Resource, versuche einfachen Dateistring
            try {
                pr.load( new FileInputStream(resrc) );
            }
            catch( Exception ex ) {
                System.out.println( ex.toString() );
            }
        }
    }

    public Properties getProperties() {
        return( props );
    }

    /**
    *	Sorgt fuer die Bildschirmdarstellung der Applikation.
    */
    public void run() {
        try {
            setSize( Integer.parseInt( props.getProperty(
                "nekjeScreenWidth") ),
            Integer.parseInt( props.getProperty("nekjeScreenHeight") ) );
            setLocation( Integer.parseInt( props.getProperty(
                "nekjeScreenX") ),
            Integer.parseInt( props.getProperty("nekjeScreenY") ) );
        }
        catch( Exception e ) {
            setSize(600,400);
            setLocation( 10, 10 );
        }
        setVisible( true );
    }

    /**
    * Hier kommt das Programm ins Rollen.
    */
    public static void main( String[] args ) {
        String tprops = "nekje.cfg";

        // Suche nach Konfigurationsdatei
        if( args.length > 0 ) {
            tprops = args[0];
        }

        Nekje app = new Nekje( tprops );
        app.run();
    }
}

