import java.util.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;

public class KlassenReferenz {

    protected static final String javaPackages[] = {
		"java.applet", "java.awt", "java.awt.color", "java.awt.datatransfer", 
		"java.awt.dnd", "java.awt.event", "java.awt.font", "java.awt.geom", 
		"java.awt.im", "java.awt.image", "java.awt.image.renderable", 
		"java.awt.print", "java.beans", "java.beans.beancontext", "java.io", 
		"java.lang", "java.lang.ref", "java.lang.reflect", "java.math", 
		"java.net", "java.rmi", "java.rmi.activation", "java.rmi.dgc", 
		"java.rmi.registry", "java.rmi.server", "java.security", 
		"java.security.acl", "java.security.cert", 
		"java.security.interfaces", "java.security.spec", "java.sql", 
		"java.text", "java.util", "java.util.jar", "java.util.zip", 
		"javax.accessibility", "javax.swing", "javax.swing.border", 
		"javax.swing.colorchooser", "javax.swing.event", 
		"javax.swing.filechooser", "javax.swing.plaf", 
		"javax.swing.plaf.basic", "javax.swing.plaf.metal", 
		"javax.swing.plaf.multi", "javax.swing.table", "javax.swing.text", 
		"javax.swing.text.html", "javax.swing.text.html.parser", 
		"javax.swing.text.rtf", "javax.swing.tree", "javax.swing.undo", 
		"org.omg.CORBA", "org.omg.CORBA.DynAnyPackage", 
		"org.omg.CORBA.ORBPackage", "org.omg.CORBA.portable", 
		"org.omg.CORBA.TypeCodePackage", "org.omg.CosNaming", 
		"org.omg.CosNaming.NamingContextPackage"
    };
    	
    protected String apiDocPath;
    protected String classPath;
    
    public void setClassPath( String cp ) {
	this.classPath = cp;
    }

    
    protected Class findClass( String className ) {
	    
    	boolean found = false;
	String  searchStr = className;
	Class c = null;
		
	// Suche ueber alle verfuegbaren Packages
	for (int index = -1; found == false && index < javaPackages.length; index++) {
		try {
	    		if (index >= 0) {		    	
	    			searchStr = javaPackages[index] + "." + className;
			} 

			c = Class.forName(searchStr);
			found = true;
		} catch (ClassNotFoundException e) {}
	} 

	if( found == false && classPath != null && classPath.length() > 0) {
		
		// Versuche Klasse im lokalen Dateisystem zu finden
		StringTokenizer st = new StringTokenizer( classPath, System.getProperty("path.separator"));
		Vector spaths = new Vector();
		
		while( st.hasMoreTokens() ) {
			String temp = st.nextToken();
			
			// Fuege ggfs. fehlenden Endslash hinzu
			if( temp.endsWith(".jar") == false ) {
				if( temp.endsWith( System.getProperty("file.separator") ) == false )
					temp += System.getProperty("file.separator");
			}
			
			// Ergaenze Protokoll wenn noetig
			if( temp.indexOf( "://" ) == -1 && temp.startsWith( "file:") == false ) {
				temp = "file:"+temp;	
			}
			
			spaths.add( temp );		
		}
		
		URL[] urls = new URL[ spaths.size() ];
		
		for(int i = 0; i < urls.length; i++ ){
			try {
				urls[i] = new URL( (String)spaths.elementAt(i) );
			}
			catch(	MalformedURLException e ) {
				System.err.println("Fehler bei URL: "+(String)spaths.elementAt(i));
			}
		}
		
		URLClassLoader classLoader = new URLClassLoader( urls );

		try {
			c = classLoader.loadClass( className );
			found = true;
		}
		catch( Exception e ) {
		}
	}
	
    	return( c );
    } 
    
    protected String print_method_or_constructor(Member member) {
    	String currentStr = "";
		Class returntype = null, parameters[], exceptions[];

		if (member instanceof Method) {
		    Method m = (Method) member;

		    returntype = m.getReturnType();
		    parameters = m.getParameterTypes();
		    exceptions = m.getExceptionTypes();
		} else {
		    Constructor c = (Constructor) member;

		    parameters = c.getParameterTypes();
		    exceptions = c.getExceptionTypes();
		} 

		currentStr += 
		    "  " + modifiers(member.getModifiers()) 
		    + ((returntype != null) ? typename(returntype) + " " : "") 
		    + "<font><strong>" + member.getName() + "</strong></font>( ";

		for (int i = 0; i < parameters.length; i++) {
		    if (i > 0) {
				currentStr += ", ";
		    } 

		    currentStr += "<font color=\"#009999\">" 
						  + typename(parameters[i]) + "</font>";
		} 

		currentStr += " )";

		if (exceptions.length > 0) {
		    currentStr += "<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;throws ";
		} 

		for (int i = 0; i < exceptions.length; i++) {
		    if (i > 0) {
				currentStr += ", ";
		    } 

		    currentStr += "<font color=\"#ff0000\">" + typename(exceptions[i]) + "</font>";
		} 

		currentStr += ";<BR>";
		
		return( currentStr );
    } 
    
    protected String typename(Class t) {
		String brackets = "";

		while (t.isArray()) {
		    brackets += "[ ]";
		    t = t.getComponentType();
		} 

		return t.getName() + brackets;
    } 

    protected String modifiers(int m) {
		if (m == 0) {
		    return "";
		} else {
		    return Modifier.toString(m) + " ";
		} 
    } 

    protected String print_fields(Field f) {
		String currentString = "  " + modifiers(f.getModifiers()) 
				      + typename(f.getType()) + " " + "<b>" + f.getName() 
				      + "</b>;<BR>";
		return( currentString );		       		      
    } 

    protected String classToHref(Class c) {
		
		String cname = c.getName();

		return (apiDocPath + cname.replace('.', '/') + ".html");
    } 

	protected String getSuperclasses( Class s ) {
		String temp ="";
		
		if( s != null ) {
			Class ss = s.getSuperclass();
			if( ss != null )
				temp = getSuperclasses( s.getSuperclass() ) + ", " + s.toString();
			else
				temp = s.toString();
		}
		return( temp );
	}
	
	protected String classHierachie( Class c ) {
	
		String htmlString = "<pre>";
		String sTemp = getSuperclasses( c );
		
		StringTokenizer st = new StringTokenizer( sTemp, "," );
		int counter = 0;
    		
    	while ( st.hasMoreTokens()) {
    		if( counter > 0 ) {
    			String space = "";
	   			htmlString += "\n";
	   			for(int i=0; i<counter; i++)
	   				space += "   ";
	   			htmlString += space + "|\n";
	   			htmlString += space + "+--- ";
	   		}
	   		htmlString += st.nextToken();
	   		counter++;
    	}
     		
		htmlString += "\n</pre>";
		return( htmlString);
	}
    
    public void setApiDocPath( String path ) {
	
	apiDocPath = path;
    }

    
    public String getHTMLReferenz( String className ) {
   		
   	String currentStr = "<html><body><font size=2>";    
    	
    	Class c = findClass( className );
    	
    	if( c != null ) {
    		try{
			currentStr += "<font size=3>";
			if (c.isInterface()) {
			    currentStr += Modifier.toString(c.getModifiers()) + " " 
							  + "<b>" + c.getName() + "</b></font>";
			} else if (c.getModifiers() != 0) {
				Class sc = c.getSuperclass();
		    	currentStr += Modifier.toString(c.getModifiers()) + " class " 
							  + "<b>" + c.getName() + "</b></font>";
			if(sc != null)				  
				currentStr += "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;extends " + sc.getName();
			} else {
		    	currentStr += Modifier.toString(c.getModifiers()) + " class " 
							 + "<b>" + c.getName()+ "</b></font>";
			} 

			Class[] interfaces = c.getInterfaces();

			if ((interfaces != null) && (interfaces.length > 0)) {
			    if (c.isInterface()) {
						currentStr += 
					    "<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;extends ";
		    	} else {
					currentStr += 
				    	"<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;implements ";
		    	} 
			} 

			for (int i = 0; i < interfaces.length; i++) {
			    if (i > 0) {
					currentStr += ", ";
		    	} 

			    currentStr += interfaces[i].getName();
			} 

			currentStr += "</font><table><tr><td bgcolor=\"#EEEEEE\">" +
				"<font size=2 color=\"#0000ff\">Klassenhierachie:</font>" + 
				classHierachie( c ) + 
				"</td></tr></table><font size=2>";

			if( apiDocPath != null ) {
				if (c.getName().indexOf("java.") != -1 
					|| c.getName().indexOf("javax.") != -1) {
				    	currentStr += "<P><a href=\"" + classToHref(c) + "\">" 
						  + "Sun Java-Referenz f&uuml;r Klasse " 
						  + c.getName() + "</a>";
				} 
			}

			currentStr += "<P><font color=\"#0000FF\">Konstruktoren</font><BR>";

			Constructor[] constructors = c.getDeclaredConstructors();

			SortedStringList sortedStrList = new SortedStringList();
			
			for (int i = 0; i < constructors.length; i++) {
				
			    sortedStrList.insert( print_method_or_constructor(constructors[i]) );
			} 

			while(true) {
				String current = (String)sortedStrList.getNextDataObject();
				
				if(current == null ) break;
				
				currentStr += current;
			}			

			currentStr += 
			    "<P><font color=\"#0000FF\">Eigenschaften/Felder</font><BR>";

			final Field[] fields = c.getDeclaredFields();
			
			SortedFieldList sortedFList = new SortedFieldList();
			
			for( int i = 0; i < fields.length; i++) {
				sortedFList.insert( fields[i] );
			}
			
			while(true) {
				Field current = (Field)(sortedFList.getNextDataObject());
				
				if(current == null ) break;
				
				currentStr += print_fields(current);
			}			


			currentStr += "<P><font color=\"#0000FF\">Methoden</font><BR>";

			final Method[] methods = c.getDeclaredMethods();
			
			SortedMethodList sortedMList = new SortedMethodList();
			
			for( int i = 0; i < methods.length; i++) {
				sortedMList.insert( methods[i] );
			}
			
			while(true) {
				Method current = (Method)(sortedMList.getNextDataObject());
				
				if(current == null ) break;
				
				currentStr += print_method_or_constructor(current);
			}
		  }
		  catch( Exception ex ) {
		  	currentStr += "Es ist ein Fehler beim Laden der Daten aufgetreten.";
		  }	
		}
		else
			currentStr += "F&uuml;r " + className + " wurde leider kein Eintrag gefunden. Sorry!";
			
	currentStr += "<font size=1><br>Referenzseite erstellt mit KlassenReferenz &copy; 2000 Espel</font></font></body></html>";

    	return currentStr;
    }
    
}

class SortedMethodList extends SortedList {

	public int compare( Object obj1Ref, Object obj2Ref ) {
	
		String obj1Name = ((Method)obj1Ref).getName();
		
		return( obj1Name.compareTo( ((Method)obj2Ref).getName() ) );
		
		
	}
}

class SortedFieldList extends SortedList {

	public int compare( Object obj1Ref, Object obj2Ref ) {
	
		String obj1Name = ((Field)obj1Ref).getName();
		
		return( obj1Name.compareTo( ((Field)obj2Ref).getName() ) );
		
	}
}

class SortedStringList extends SortedList {

	public int compare( Object obj1Ref, Object obj2Ref ) {
		return( ((String)obj1Ref).compareTo( (String)obj2Ref ) );		
	}
}

class RefClassLoader extends ClassLoader {
	
	String rootPath;
	
	public RefClassLoader( String rootPath ) {
		this.rootPath = rootPath;
	}

	public Class findClass( String name )
		throws ClassNotFoundException {

			
		byte[] b = loadClassData( name ) ;
		
		if( b == null ) throw
			new ClassNotFoundException( name );
			
		return defineClass( name, b, 0, b.length );		
	}
	
	private byte[] loadClassData( String name ) {
	
		try {
			name = rootPath + name.replace('.',File.separatorChar) + ".class";
			File f = new File( name );
			FileInputStream fi = new FileInputStream(name);
			byte cByte[] = new byte[(int)f.length()];
			fi.read(cByte);
			fi.close();
			return cByte;
		}
		catch( Exception ex ) {}
		
		return null;
	}
}
														    															    						    		            								    								    		    				    		    																									    																					    										    		            								    								    		    				    		    																									    																					    										    		            								    								    		    				    		    								