import java.io.*;
import java.lang.*;
import java.lang.reflect.*;
import java.net.*;

class JindentPluginWrapper extends NekjeIndentClass {

	protected String cName;
	protected Class intendClass;
	protected Method init;
	protected Method parse;
	protected boolean valid = false;
	
	public void loadPlugin() {
		
		if( url != null && name != null ) {
	
			try {
				URL cpurl = new URL( url );
				URLClassLoader cl = new URLClassLoader( 
							new URL[] {cpurl} );
			
				URL[] debug = cl.getURLs();
				intendClass = cl.loadClass(name);

				Class[] a1 = { String[].class };
				Class[] a2 = { InputStream.class, OutputStream.class };

				init = intendClass.getMethod("initParser",a1);
				parse = intendClass.getMethod("parseInputStream",a2);
				
				valid = true;
			}
			catch( Exception e ) {
				System.err.println(e.toString());	
			}		
		}
	}	


	public boolean isValid() {
		return valid;
	}
		
	
	public void parse( InputStream in, OutputStream out ) {

      		/* Set Jindent parameters to mute mode */
      		String params[] = {
         		"-p", "Sun-Style.jin", "-m"
      		}; 

      		/* Invoking Jindent, outputstream to console */	   
		try {
			Object[] o1 = {params};
			init.invoke( null, o1 );
        		/* Start parsing */
			Object[] o2 = {in,out};  
  			parse.invoke( null, o2);
      		} catch (Exception je) {}
	}
}