import java.io.*;
import java.lang.*;
import java.lang.reflect.*;
import java.net.*;

/**
* Nekje Plugin-Wrapper fuer IBM Java CodeFormatter
*/

public class CodeFormatterPluginWrapper extends NekjeIndentClass {

	protected String cName;
	protected Class indentClass;
	protected Object indentObject;
	protected Method indentationStep;
	protected Method parse;
	protected boolean valid = false;
	
	public void loadPlugin() {
		if( url != null && name != null ) {
	
			try {
				URL cpurl = new URL( url );
				
				URLClassLoader cl = new URLClassLoader( 
							new URL[] {cpurl} );				
			
				indentClass = cl.loadClass(name);
				indentObject = indentClass.newInstance();

				Class[] a1 = { Reader.class, Writer.class };

				parse = indentClass.getMethod("formatCode",a1);
				
				int step = 4;
				Class[] a2 = { Integer.TYPE };
				indentationStep = 
					indentClass.getMethod("setIndentationStep",a2);
					
				
				Object[] o2 = {  new Integer(step) };	
				indentationStep.invoke( indentObject, o2 );
				valid = true;
			}
			catch( Exception e ) {
				System.err.println( e.toString() );	
			}		
		}
	}	

	public boolean isValid() {
		return valid;
	}
	
	public void parse( InputStream in, OutputStream out ) {

		char[] arr = new char[20];
		
     		/* Reader und Writer muessen zunaechst erzeugt werden */
      		InputStreamReader inReader = new InputStreamReader( in );
      		OutputStreamWriter outWriter = new OutputStreamWriter( out );
      	
		try {

			Object[] o1 = {inReader, outWriter};  
  			parse.invoke( indentObject, o1);
  			outWriter.flush();
  			
      		} catch (Exception je) {
      			System.err.println( je.toString() );	
      		}
	}
}