package javakurs.io;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
* Stellt ein universelles Eingabefenster zur Verf&uuml;gung.
* 
*
* <p>Beispiel f&uuml;r den Gebrauch der Klasse:
*
* <pre>
* public class EingabeFensterDemo {
*	EingabeFenster ef;
*	}
*
* </pre>
*
* @author Hubertus Espel
* @version 00-03-31
*/
public class EingabeFenster extends Frame {
	protected Panel centerPanel;
	protected Panel eingabeFelder;
	protected Panel labelFelder;
	protected Button okButton;
	protected IOSchnittstelle iofenster;
	protected Vector fieldVector;
	
	/**
	* Konstruktor der Klasse
	*
	* @param iof Objekt, welches das Interface IOSchnittstelle implementiert hat.
	* @see IOSchnittstelle#action
	*/
	public EingabeFenster( IOSchnittstelle iof ) {
	
		setFont(new Font("SansSerif", Font.PLAIN, 12));
		
		iofenster = iof;
		fieldVector = new Vector();
		setResizable( false );
		setTitle("Objekt der Klasse javakurs.io.EingabeFenster");
		setLayout( new BorderLayout() );
	
		centerPanel = new Panel();
		centerPanel.setLayout( new GridLayout(1,2) );
	
		eingabeFelder = new Panel();
		eingabeFelder.setLayout( new GridLayout(-1,1) );
		labelFelder = new Panel();		
		labelFelder.setLayout( new GridLayout(-1,1) );

		centerPanel.add( labelFelder );	
		centerPanel.add( eingabeFelder );

		okButton = new Button("OK");
		okButton.addActionListener( new ActionListener() {
			public void actionPerformed( ActionEvent e ) {
				try {
					iofenster.action();
				}
				catch( Exception ex ) {
					System.err.println( ex.toString() );
				}					
			}	
		} );
						
		add( okButton, BorderLayout.SOUTH );
		add( centerPanel, BorderLayout.CENTER );
		
		this.addWindowListener(
			new WindowAdapter() {
				// Bei Programmexit-Event beende Programm
				public void windowClosing(WindowEvent e) {
					System.exit(0);
				}
			}
		);
	}

	/**
	* Zeigt das Eingabefenster auf dem Bildschirm an.
	*
	*	@param value Bei true wird das Eingabefenster sichtbar, bei false wird es unsichtbar.
	*
	* Die Methode muss aufgerufen werden nach der Erzeugung des Objekts
	* und der Zuweisung der Eingabefelder mit der Methode @see EingabeFenster#addLabelField
	*/
	public void setVisible( boolean value ) {
		if( value == true ) {
			
			FontMetrics fm = getFontMetrics( getFont() );
			int height = fm.getHeight();
			int cc = fieldVector.size() + 1;
			Dimension dim = getToolkit().getScreenSize();
			setLocation(0,0);
		    this.setSize( dim.width/2, cc*(height+height/2) );
		    super.setVisible(true);	
		}
		else
			super.setVisible(false);
	}
	
	/**
	* Fuegt dem Eingabefenster ein Texteingabefeld mit zugehrigem
	* Prompt (Label) hinzu.
	*
	* @param str Text fuer Label 
	*/
	public void addField( String str ) {
		labelFelder.add( new Label( str ) );
		TextField tf = new TextField();
		eingabeFelder.add( tf );	
		fieldVector.addElement( tf );		
	}
	
	/**
	*	Gibt den Inhalt des Eingabefeldes an Position num zurck.
	*	
	*	@param num Position des Eingabefeldes (0 ... n );
	*
	*	@return Inhalt als String
	*/
	public String getTextFromField( int num ) {
		String t = "";
		try {
			t = ((TextField)fieldVector.elementAt(num)).getText();
		}
		catch( Exception e ) {
			t = "<void>";
		}
		
		return( t );
	}
	
	/**
	*	Lscht den Inhalt des Eingabefeldes an Position num.
	*
	*	@param num Position des Eingabefeldes (0 ... n)
	*/
	public void clearField( int num ) {
		try {
			((TextField)fieldVector.elementAt(num)).setText("");
		}
		catch( Exception e ) {
		}
	}	
	
	/**
	*	Lscht den Inhalt aller Eingabefelder.
	*/
	public void clear() {
		
		for( Enumeration e = fieldVector.elements(); 
			e.hasMoreElements(); ) {
		
			((TextField)e.nextElement()).setText("");		
		}
	}	
	
	
}
																																																					
