package javakurs.io;

import java.awt.*;
import java.awt.event.*;
import java.net.*;

class BildFenster extends Frame {

	protected ImageCanvas ic;
	
	public BildFenster() {
	
		this.addWindowListener(
			new WindowAdapter() {
				// Bei Programmexit-Event beende Programm
				public void windowClosing(WindowEvent e) {
					System.exit(0);
				}
			}
		);
		ic = new ImageCanvas( this );
		add(ic);	
	}
	
	public void setVisible( boolean value ){

		Dimension dim = getToolkit().getScreenSize();
		
		if( value == true && ic.getImageStatus() != false ) {
				
				// Setze Groesse und Position des Bildschirmfensters
				int ypos = Math.max(0,dim.height-ic.img.getHeight(ic));
				int xpos = Math.max(0,dim.width-ic.img.getWidth(ic));
				if( ic.img.getHeight(ic) < dim.height/2 )
					xpos = dim.height/2;
		
				setLocation( xpos,ypos);
				setSize( ic.img.getWidth(ic), ic.img.getHeight(ic) );

				super.setVisible( true);
				resizeFrame();
		}
		else {
			if( value == true ) {
				setLocation( 0,0);
				setSize( dim.width/2, dim.height/4 );				
			}
			
			super.setVisible( value );	
		}
			
	}
	
	public void setImage( String imgName ) {

		try {
			URL url = new URL( imgName );
			ic.loadImage( url );	
		}
		catch( MalformedURLException e ){
			ic.loadImage( imgName );
		}			
		
		setTitle( imgName );
	}
	
	private void resizeFrame() {
			int imgHeight = ic.img.getHeight(ic);
			int imgWidth = ic.img.getWidth(ic);
			int canvasHeight = ic.getSize().height;
			int canvasWidth = ic.getSize().width;
			//System.err.println( "Bild: " + ic.img.getHeight(ic) + " " + ic.img.getWidth(ic) );
			//System.err.println( "Canvas: " + canvasHeight + " " + canvasWidth );
			//System.err.println( "Rahmen: " + getSize().height + " " + getSize().width );
			
			// Justiere Groesse des Rahmens
			setSize( getSize().width + (imgWidth - canvasWidth), 
					getSize().height + (imgHeight - canvasHeight));
			
			int xpos = getLocation().x;
			int ypos = getLocation().y;		
			
			// Justiere Position des Rahmens
			setLocation( Math.max(0,xpos - (imgWidth - canvasWidth)), 
						Math.max(0,ypos - 2*(imgHeight - canvasHeight)) );
			
			validate();		
	}	
}

class ImageCanvas extends Canvas {
	protected Frame parent;
	Image img;
	protected boolean imgStatus;
	
	public ImageCanvas( Frame p ){
		parent = p;	
		img = null;	
		imgStatus = false;
	}
		
	public void loadImage( String imgName ) {
		img = Toolkit.getDefaultToolkit().getImage( imgName );
		if( img != null )
			trackImageLoading();
	}
	
	public void loadImage( URL url ) {
		img = Toolkit.getDefaultToolkit().getImage( url );
		if( img != null )
			trackImageLoading();
	}
		
	private void trackImageLoading() {
			
		MediaTracker tracker = new MediaTracker( this );
		tracker.addImage( img, 0 );
		
		try {
			while( tracker.checkID(0) != true )
				tracker.waitForID(0);		
			imgStatus = !tracker.isErrorID(0);
		}
		catch( Exception e ) {
		}

	}
		
	public boolean getImageStatus() {
		return imgStatus;
	}

	public void paint( Graphics g ) {
		if( img != null && imgStatus == true ){
			g.drawImage(img, 0, 0, this);	
		}
		else
			g.drawString("Fehler beim Laden des Bildes.", 20,20 );	
	}
}
														
