package javakurs.io;

import java.awt.*;
import java.awt.event.*;

/**
* Stellt ein universelles Ausgabefenster f&uuml;r Textausgaben zur Verf&uuml;gung.
* @author Hubertus Espel
* @version 00-06-10
*/
public class AusgabeFenster extends Frame {

	protected TextArea ta;
	protected Label status;
	protected int xpos = -1;
	protected int ypos = -1;
	protected int height = -1;
	protected int width = -1;
	
	/**
	* Konstruktor der Klasse.
	* <p>Es wird ein Fenster angelegt mit einem Textausgabebereich. Erst durch den
	* Aufruf der Methode setVisible() wird das Ausgabefenster auf dem Desktop angezeigt.</p>
	*/
	public AusgabeFenster() {
		setTitle("Objekt der Klasse javakurs.io.AusgabeFenster");
		setLayout( new BorderLayout() );
		ta = new TextArea();
		ta.setEditable(false);

		this.add( ta, BorderLayout.CENTER );
		
		this.addWindowListener(
			new WindowAdapter() {
				// Bei Programmexit-Event beende Programm
				public void windowClosing(WindowEvent e) {
					System.exit(0);
				}
			}
		);

	}
	
	/**
	*	Konstruktor der Klasse.
	*	@param x Horizontale Position des Fensters.
	*	@param y Vertikale Position des Fensters.
	*	@param width Breite des Fensters.
	*	@param height H&ouml;he des Fensters.
	*/
	public AusgabeFenster(int x, int y, int width, int height){
		this();
		xpos = x;
		ypos = y;
		this.width = width;
		this.height = height;
	}
	
	/**
	*	F&uuml;gt am Fu&szlig; des Fensters eine Statuszeile ein.
	*/
	public void addStatus() {
		status = new Label("");
		status.setBackground(Color.lightGray);
		this.add( status, BorderLayout.SOUTH );	
	}
	
	/**
	*	Gibt eine Statusmeldung aus.
	*	@param str Meldung, die in der Statuszeile ausgegeben wird.
	*/
	public void setStatus( String str ) {
	
		if( status != null ) {
			status.setText(str);	
		}	
	}
	
	/**
	*	Setzt die Farbe der Textausgabe.
	*	@param c Objekt vom Typ Color, welches die Textfarbe enth&auml;lt.
	*/
	public void setTextColor( Color c ){
		ta.setForeground( c );
	}
	
	/**
	*	Setzt die Schriftart der Textausgabe.
	*	@param f Objekt vom Typ Font, welches die Schriftart enth&auml;lt.
	*/
	public void setTextFont( Font f ){
		ta.setFont( f );	
	}
	
	/**
	* Stellt das Ausgabefenster auf dem Bildschirm dar.
	* 
	* @param value Bei true wird das Fenster sichtbar gemacht, bei false wird das Fenster unsichtbar.
	*		
	* Hinweis: Diese Methode muss nach der Erzeugung des Objekts aufgerufen werden.
	*/
	public void setVisible( boolean value ) {
		if( value == true ) {
			if(xpos == -1 || ypos == -1 || height == -1 || width == -1){
				Dimension dim = getToolkit().getScreenSize();
				xpos = dim.width/2;
				ypos = 0;
				width = dim.width/2;
				height = dim.height/2;
			}
				
			this.setLocation(xpos,ypos);
			this.setSize(width,height);
		}	
				
		super.setVisible(value);	
	}
	
	/**
	* Gibt einen Textstring im Fenster aus.
	*
	* @param str Text,der angezeigt werden soll.
	*/
	public void print( String str ) {
		ta.append( str );	
	}
	
	/**
	* Gibt einen Textstring im Fenster aus und erzeugt anschlieend
	* einen Zeilenumbruch.
	*
	* @param str Text,der angezeigt werden soll.
	*/
	public void println( String str ) {
		ta.append( str + "\n" );	
	}
	
	/**
	* Sorgt fuer eine Pause in der Abfolge der Textausgaben. 
	* Die gesamte Anwendung wird dabei unterbrochen.
	*
	* @param millisecs Zeitdauer der Pause in Millisekunden 
	*
	*/
	public void sleep( int millisecs )
	{
		try {
			Thread.sleep( millisecs );	
		}
		catch( InterruptedException e ) {
			System.err.println(e.toString());	
		}
		
	}
	
	/**
	* Lscht alle Ausgaben im Bildschirmfenster. Das Fenster bleibt sichtbar.
	*/
	public void clear() {
		ta.setText("");	
	}
}

																													