package javakurs.io;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
*	Die Klasse stellt ein Ausgabefenster bereit f&uuml;r Textausgaben bereit.
* 
*
*       <p>Beispiel f&uuml;r den Gebrauch der Klasse:
* 	<pre>
*	import javakurs.io.*;
* 	public class AusgabeDemo {
*		public static void main( String[] args ) {
*			Ausgabe.println( "Hallo Welt" );
*                       Ausgabe.setStatus( "Dies ist ein Bespiel f&uuml;r eine Ausgabe." );
*		}
*	}
* </pre>
*	<p>Das Ausgabefenster hat f&uuml;r das Beispiel AusgabeDemo das folgende Aussehen:<br><br>
*	<img src="Ausgabe.png">
*
* 	@author Hubertus Espel
* 	@version 00-09-30
*/
public final class Ausgabe extends Frame {

	private static final Vector imgVector = new Vector();
	private static final SimpleAusgabe af = new SimpleAusgabe();

	private Ausgabe() {
	}

	/**
	*	Zeigt das Ausgabefenster auf dem Bildschirm an, wenn zuvor nicht sichtbar war.
	*/
	public static void showWindow() {
		af.setVisible( true );
		for( int i = 0; i < imgVector.size(); i++ )
			((BildFenster)imgVector.elementAt(i)).setVisible( true );
	}
	
	/**
	*	Das Ausgabefenster wird unsichtbar, wenn es zuvor auf dem Bildschirm sichtbar war.
	*/
	public static void hideWindow() {
		af.setVisible( false );
		for( int i = 0; i < imgVector.size(); i++ )
			((BildFenster)imgVector.elementAt(i)).setVisible( false );
	}

	/**
	*	Gibt einen Textstring im Ausgabefenster aus. Es erfolgt kein Zeilenumbruch am Ende des Strings.
        *       @param str Referenz auf ein Stringobjekt, welches den Textstring enth&auml;lt.
	*/
	public static void print( String str ) {
		if( af.isVisible() == false ) 
			showWindow();			
		af.print( str );	
	}

	/**
	*	Gibt einen Wert vom Datentyp double im Ausgabefenster aus. Es erfolgt kein Zeilenumbruch am Ende der Ausgabe.
	*	@param wert Doublewert, der ausgegeben werden soll.
	*/
	public static void print( double wert ) {
		print( wert + "" );
	}
	
	/**
	*	Gibt einen Wert vom Datentyp long im Ausgabefenster aus. Es erfolgt kein Zeilenumbruch am Ende der Ausgabe.
	*	@param wert Longwert, der ausgegeben werden soll.
	*/
	public static void print( long wert ) {
		print( wert + "");
	}
	
	/**
	*	Gibt einen Textstring im Ausgabefenster aus. Es erfolgt ein Zeilenumbruch am Ende des Strings.
        *       @param str Referenz auf ein Stringobjekt, welches den Textstring enth&auml;lt.
	*/
	public static void println( String str ) {
		print( str + "\n" );	
	}

	/**
	*	Gibt einen Wert vom Datentyp double im Ausgabefenster aus. Es erfolgt ein Zeilenumbruch am Ende der Ausgabe.
	*	@param wert Doublewert, der ausgegeben werden soll.
	*/
	public static void println( double wert ) {
		print( wert + "\n" );	
	}
		
	/**
	*	Gibt einen Wert vom Datentyp long im Ausgabefenster aus. Es erfolgt ein Zeilenumbruch am Ende der Ausgabe.
	*	@param wert Longwert, der ausgegeben werden soll.
	*/
	public static void println( long wert ) {
		print( wert + "\n" );	
	}
	
	/**
	*	L&ouml;scht den Inhalt des Ausgabefensters
	*/
	public static void clear() {
		af.clear();	
		for( int i = imgVector.size()-1; i >= 0; i-- ){
			BildFenster temp = (BildFenster)imgVector.elementAt(i);
			imgVector.removeElementAt(i);
			temp.setVisible( false );
			temp.dispose();
		}		
	}

	/**
	*	Gibt einen Textstring in der Statuszeile des Ausgabefensters aus.
	*	@param str Referenz auf ein Stringobjekt, welches den auszugebenden Textstring enth&auml;lt.
	*/
	public static void setStatus( String str ) {
		af.setStatus( str );	
	}
	
	/**
	*	Gibt ein GIF- oder JPEG-Bild in einem gesonderten Ausgabefenster aus.
	*	@param bildAdresse Dateipfad oder URL der Bilddatei
	*/
	public static void showImage( String bildAdresse ){
	
		BildFenster bf = new BildFenster();
		bf.setImage( bildAdresse );
		
		imgVector.addElement( bf );
		bf.setVisible( true );	
	}
}

class SimpleAusgabe extends AusgabeFenster {

	public SimpleAusgabe() {
		super();
		super.addStatus();
		setTitle("Objekt der Klasse javakurs.io.SimpleAusgabe");
	}
}

																																																													
