package javakurs.auto;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.util.*;
import java.net.*;

public class Strasse extends Frame {

	private AutoCanvas drawingBoard;
	private Vector cars;
	private Panel carPanel;
	
	private boolean firstFlag;
	private Image bgImage;
	
	private int breite;
	private	int startxpos;
	private	int ypos;
	private	int endxpos;
	
	/**
	*	Konstruktor fr die Klasse Strasse
	*/
	public Strasse(){
		
		setTitle("Wir fahrn, fahrn, fahrn auf der Autobahn...");
		breite = 6;
		startxpos = 0;
		endxpos = 599;
		ypos = 200;
		firstFlag = true;
		
		cars = new Vector();
		
		drawingBoard = new AutoCanvas( new Dimension(100,100) );
			
		addWindowListener(
			new WindowAdapter() {
				public void windowClosing( WindowEvent e ) {
					System.exit(0);
				}
				
			}
		);			
		
		addComponentListener(
			new ComponentAdapter() {
				public void componentResized( ComponentEvent e ) {
					Toolkit.getDefaultToolkit().beep();
					drawingBoard.deleteImageBuffer();
					endxpos = getSize().width-1;
				}
				
			}
		);
		
		add( drawingBoard, BorderLayout.CENTER );
		drawingBoard.setStrasse( this );

	}
	
	void repaintCars(int x, int y, int width, int height) {
		drawingBoard.repaint(x,y,width,height);
	}
	
	/**
	*	Zeichnet die Strasse mit allen zugehrigen Autos
	*/
	synchronized void paintStreet( Graphics g ) {
		if( bgImage != null ) {
			g.drawImage( bgImage, getSize().width/2-bgImage.getWidth(drawingBoard)/2, 
				ypos-bgImage.getHeight(drawingBoard), drawingBoard);
		}
		
		g.fillRect( startxpos, ypos, getSize().width, breite);
		for(Enumeration e = cars.elements(); e.hasMoreElements(); ) {
			Auto currentAuto = (Auto)e.nextElement();
			currentAuto.paint( g, drawingBoard );
		}		
	}
	
	/**
	*	&Ouml;ffnet oder schlie&szlig;t das Strassenfenster. Diese Methode sollte erst aufgerufen
	*	werden, wenn dem Strassenfenster alle Objekte hinzugef&uuml;gt wurden. 
	*	@param value Bei 'true' erfolgt Anzeige, 'false' schlie&szlig;t das Fenster
	*/
	public void setVisible( boolean value ) {
	
		super.setSize(endxpos+1,ypos+200);
				
		if( firstFlag && carPanel != null ) {
			firstFlag = false;
			this.add( carPanel, BorderLayout.SOUTH );
		}
		
		super.setVisible( value );
	}
	
	int getLength() {
		return endxpos-6;
	}
	
	private void createCarPanel() {	
		carPanel = new Panel();
		carPanel.setLayout( new GridLayout(0,1) );
	}
	
	/**
	*	F&uuml;gt ein Hintergrundbild (GIF- oder JPEG-Datei) ein.
	*	@param imgName Dateipfad oder URL der GIF- oder JPEG-Datei
	*/
	public void setBackgroundImage( String imgName ) {

		try {
			URL url = new URL( imgName );
		    bgImage = Toolkit.getDefaultToolkit().getImage( url );
		}
		catch( MalformedURLException e ){
 		    bgImage = Toolkit.getDefaultToolkit().getImage( imgName );
		}
		prepareImage( bgImage, this );		
	}
	
	/**
	*	Setzt ein Objekt vom Typ Auto auf die Strasse.
	*	@param auto Rferenz auf ein Objekt vom Typ Auto
	*/
	public void add( Auto auto ) {
		
		cars.add( auto );

		prepareImage( auto.getImage(), this );
		auto.setStreet( this );
		if( auto.getID() == null )
			auto.setID("Auto " + cars.size() );
		
		short functions = auto.getFunctions();
		
		if( functions > 0 ) {
		
			if( carPanel == null )
				createCarPanel();
	
			Panel p = new Panel();		
			p.add( new Label( auto.getID() ) );	
			
			if( (functions & Auto.MOTOR) == Auto.MOTOR ) {
				Button b = new Button("Motor an");
				b.addActionListener( new MotorAnListener( auto ) );
				p.add( b );
				
				b = new Button("Motor aus");
				b.addActionListener( new MotorAusListener( auto ) );
				p.add( b );
			}

			if( (functions & Auto.GASPEDAL) == Auto.GASPEDAL ) {
				Button b = new Button("Gib Gas");
				b.addActionListener( new StartListener( auto ) );
				p.add( b );
			}
			
			if( (functions & Auto.BREMSE) == Auto.BREMSE ) {					
				Button b = new Button("Stopp");
				b.addActionListener( new StoppListener( auto ) );
				p.add( b );
			}	
			if( (functions & Auto.GAENGE) == Auto.GAENGE ) {
				Button b = new Button("Vorwrts");
				b.addActionListener( new VorwaertsListener( auto ) );
				p.add( b );
				
				b = new Button("Rckwrts");
				b.addActionListener( new RueckwaertsListener( auto ) );
				p.add( b );
			}				
			carPanel.add(p);
		}
		
		while( (checkImage( auto.getImage(), this ) & ALLBITS) != ALLBITS )
		;
		auto.setYPos( ypos+breite/2, drawingBoard );
		auto.setXPos( cars.size()*10, drawingBoard );
		repaint();
	}	
}

class AutoCanvas extends Canvas {

		private Image dbImage = null;
		private Graphics dbGraphics = null;
		private int xpos, ypos;
		private Dimension preSize;		
		private Strasse myRoad = null;
		
		public AutoCanvas( Dimension preSize ) {
			this.preSize = preSize;
		}
		
		public Dimension getPreferredSize() {
			return preSize;
		}
		
		public Dimension getMinimumSize() {
			return preSize;
		}

		public Dimension getMaximumSize() {
			return preSize;
		}
		
		public void deleteImageBuffer() {
			dbImage = null;
		}
		
		public void paint( Graphics g ) {
			if(myRoad != null)
				myRoad.paintStreet( g );
		}	

		public void update( Graphics g ) {
		
			//Double-Buffer initialisieren
			if (dbImage == null) {
		       dbImage=createImage(this.getSize().width,this.getSize().height);
		       dbGraphics = dbImage.getGraphics();
		    }
		    
		    dbGraphics.setClip( g.getClip() );
		    
		    // Hintergrund lschen
			dbGraphics.setColor( getBackground() );
			dbGraphics.fillRect(0,0,this.getSize().width,this.getSize().height);
			// Vordergrund zeichnen
			dbGraphics.setColor(getForeground());
			paint(dbGraphics);
			// Offscreen anzeigen
			g.drawImage(dbImage,0,0,this);
		}
		

		public void setStrasse( Strasse road ) {
			myRoad = road;
		}
		
}																																																																																										