package javakurs.auto;

import java.awt.*;
import java.awt.image.*;

public class Auto implements Runnable {

	private Strasse street;
	private Image carImg;
	private Thread animation;
	private String carId;
	private short carFunctions;
	private int carWidth;
	private int carHeight;
	
	private int xpos;
	private int ypos;
	private int ypos_org;
	private int intervall;

	static final boolean MOVE = true;
	static final boolean WAIT = false;
	static final boolean OFF = false;
	static final boolean ON = true;
	static final short VOR = 0;
	static final short RUECK = 1;
	
	private boolean carStatus = WAIT;
	private boolean engineStatus = OFF;
	private short direction = VOR;
	
	/**
	*	Konstante f&uuml;r Einbau eines Motors
	*/
	public static final short MOTOR = 1;
	
	/**
	*	Kontante f&uuml;r Einbau eines Gaspedals
	*/
	public static final short GASPEDAL = 2;
	
	/**
	*	Konstante f&uuml; Einbau einer Bremse
	*/
	public static final short BREMSE = 4;
	
	/**
	*	Konstante f&uuml;r Einbau von Vorw&auml;rts- und R&uuml;ckw&auml;rtsgang
	*/
	public static final short GAENGE = 8;

	/**
	*	Erzeugt ein Auto. Standardfarbe ist 'blau'.
	*/
	public Auto() {
		xpos = 10;
		ypos = -1;
		intervall = 100;
		setColor("blau");
	}
	
	/**
	*	Setzt die Farbe des Autos.
	*	@param colorStr Farbe des Autos (verf&uuml;gbar: 'blau', 'rot', 'gruen'):
	*/
	public void setColor( String colorStr ) {
	
		String res_string = null;
				
		if( colorStr.equals("rot") == true ) {
			res_string = "car_red.gif";			
		}
		else if( colorStr.equals("gruen") == true ) {
			res_string = "car_green.gif";	
		}	
		else {
			res_string = "car_blue.gif";
		}
				
		carImg = 
			Toolkit.getDefaultToolkit().getImage( getClass().getResource( res_string ) );		
	}

	/**
	* Zeichnet das Auto
	*/
	void paint( Graphics g, AutoCanvas o ) {
	
		if( ypos >= 0 ){
			if( carWidth == 0 )
				carWidth = carImg.getWidth(o);
			g.drawImage(carImg, xpos, ypos, o);
		}	
	}
	
	void setStreet( Strasse str ) {
		street = str;
	}
		
	void setYPos( int ypos, AutoCanvas o ) {
		if( carHeight == 0 )
			carHeight = carImg.getHeight(o);
			
		this.ypos = ypos - carHeight;
		this.ypos_org = this.ypos;
	}
	
	void setXPos( int xpos, AutoCanvas o ) {
		if( carWidth == 0 )
			carWidth = carImg.getWidth(o);
		this.xpos = xpos;
		
		if( this.xpos < 0 ) {
			this.xpos = 0;
		}
			
		if( this.xpos > (street.getLength()- carWidth) ) {
			this.xpos = ( street.getLength() - carWidth );
		}
	}
	
	void setDirection( short direction ) {
		this.direction = direction;
	}
	
	void setMotor( boolean status ) {
		engineStatus = status;
		
		if( status == ON && animation == null ) {
			intervall = 100;
			animation = new Thread(this);
			animation.start();
		}		
		else {
			setCar( WAIT );	
		}
		
	}
	
	void setCar( boolean status ) {
		if( status == MOVE ) {
			if( engineStatus == ON && animation != null ) {
				ypos = ypos_org;
				carStatus = status;
				intervall = (int)((double)intervall/1.5);
				if( intervall < 10 ) intervall = 10;
			}
		}	
		else {
			carStatus = status;	
			intervall = 100;
		}
		
	}	
	
	/**
	*	Setzt ein Kennzeichen f&uuml;r das Auto
	*	@param id Kennzeichen als Textstring
	*/
	public void setID( String id ) {
		carId = id;
	}
	
	/**
	*	Liefert das Kennzeichen des Autos
	*	@return Kennzeichen des Autos als Textstrings
	*/
	public String getID() {
		return carId;
	}
	
	Image getImage() {
		return carImg;
	}	
	
	/**
	*	F&uuml;gt eine Funktion dem Auto hinzu.
        *       @param function Konstante f&uuml;r eine Autofunktion (verf&uuml;gbar: 'Auto.MOTOR', 'Auto.GASPEDAL',
        *       'Auto.BREMSE', 'Auto.GAENGE').
	*/
	public void addFunction( short function ) {
		carFunctions |= function;
	}	
	
	short getFunctions() {
		return carFunctions;
	}
	
	/**
	*	Setzt das Auto in Bewegung (nur interner Gebrauch). Diese Methode sollte nicht aufgerufen werden. Sie ist f&uuml;r
	* 	die interne Steuerung des Autos notwendig.
	*/
	public void run() {
		
		int xorigin = xpos;
		int yorigin = ypos;
		
		while( engineStatus == ON ) {
		
			xorigin = xpos;
			yorigin = ypos;
		
			if( carStatus != WAIT ) {
				if( direction == VOR )
					xpos++;
				else 
					xpos--;
			}
			else {
				if( ypos == ypos_org )
					ypos -= 2;
				else
					ypos = ypos_org;	
			}
			
			if( xpos < 0 ) {
				xpos = 0;
				setCar( WAIT );
			}
			
			if( xpos > (street.getLength()- carWidth) ) {
				xpos = ( street.getLength() - carWidth );
				setCar( WAIT );
			}
			
			street.repaintCars( Math.min(xorigin,xpos),
								ypos_org-2, 
								Math.abs(xorigin-xpos)+carWidth, 
								2+carHeight );
			
			try {
				animation.sleep( intervall );
			}
			catch ( InterruptedException e ) {
				System.exit(1);
			}		
		}
		
		animation = null;
		xorigin = xpos;
		yorigin = ypos;
		
		ypos = ypos_org;
		street.repaintCars( Math.min(xorigin,xpos),
							ypos_org-2, 
							Math.abs(xorigin-xpos)+carWidth, 
							Math.abs(yorigin-ypos)+carHeight );
	}	
}
																														
