/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NekjeWBPanel
extends JPanel
implements ChangeListener {
    public JTabbedPane wbTabs = null;
    public NekjeActionSet actionSet;
    private Nekje app;
    private int tabCounter;
    protected NekjeIndentClass indentObject = null;

    NekjeWBPanel(Nekje nekje) {
        this.app = nekje;
        this.loadIndentPlugin();
        this.actionSet = new NekjeActionSet(this);
        this.tabCounter = 0;
        this.wbTabs = new JTabbedPane();
        this.wbTabs.addChangeListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.wbTabs, "Center");
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.wbTabs.getSelectedIndex() != -1) {
            this.getCurrentEditor().activateEditor();
        }
    }

    public void changedUpdate() {
        this.wbTabs.setTitleAt(this.wbTabs.getSelectedIndex(), this.wbTabs.getTitleAt(this.wbTabs.getSelectedIndex()) + "*");
    }

    public Nekje getApplication() {
        return this.app;
    }

    public Properties getProperties() {
        return this.app.props;
    }

    public NekjeScrollEditorPanel getEditorAt(int n) {
        return (NekjeScrollEditorPanel)this.wbTabs.getComponentAt(n);
    }

    public NekjeScrollEditorPanel getCurrentEditor() {
        return this.getEditorAt(this.wbTabs.getSelectedIndex());
    }

    public NekjeTextArea getCurrentTextArea() {
        return ((NekjeScrollEditorPanel)this.wbTabs.getSelectedComponent()).getTextArea();
    }

    public String getCurrentTextToken() {
        return this.getCurrentEditor().getCaretText();
    }

    public NekjeReference getReferenceBrowser() {
        return this.app.getReferenceBrowser();
    }

    public boolean hasTab() {
        return this.wbTabs.getTabCount() > 0;
    }

    public int getTabCount() {
        return this.wbTabs.getTabCount();
    }

    public void addNewTab() {
        ++this.tabCounter;
        String string = "Datei " + this.tabCounter;
        NekjeScrollEditorPanel nekjeScrollEditorPanel = new NekjeScrollEditorPanel(this, null, null, true);
        this.wbTabs.addTab(string, nekjeScrollEditorPanel);
        this.wbTabs.setSelectedIndex(this.wbTabs.getTabCount() - 1);
        nekjeScrollEditorPanel.activateEditor();
    }

    public void addOpenTab() {
        NekjeFileDialog nekjeFileDialog = new NekjeFileDialog(this.app, 0, this.app.getProperties().getProperty("workingDirectory"), null);
        if (nekjeFileDialog.getFile() != null) {
            NekjeScrollEditorPanel nekjeScrollEditorPanel = new NekjeScrollEditorPanel(this, nekjeFileDialog.getDirectory(), nekjeFileDialog.getFile(), false);
            this.wbTabs.addTab(nekjeFileDialog.getFile(), nekjeScrollEditorPanel);
            this.wbTabs.setSelectedIndex(this.wbTabs.getTabCount() - 1);
            nekjeScrollEditorPanel.activateEditor();
            this.app.getProperties().setProperty("workingDirectory", nekjeFileDialog.getDirectory());
        }
    }

    public boolean activateTab(String string) {
        int n = 0;
        while (n < this.getTabCount()) {
            if (string.equals(this.getFileNameAt(n))) {
                this.wbTabs.setSelectedIndex(n);
                this.getEditorAt(n).activateEditor();
                return true;
            }
            ++n;
        }
        return false;
    }

    public void gotoLine(int n) {
        this.getCurrentEditor().setFirstLine(n);
    }

    public boolean closeSelectedTab(boolean bl) {
        boolean bl2 = true;
        if (this.hasTab()) {
            if (bl) {
                bl2 = this.changedDialog();
            }
            if (bl2) {
                this.wbTabs.removeTabAt(this.wbTabs.getSelectedIndex());
            }
        }
        return bl2;
    }

    public boolean closeAllTabs() {
        boolean bl = true;
        while (bl && this.hasTab()) {
            bl = this.closeSelectedTab(true);
        }
        return bl;
    }

    public boolean saveTabAt(int n, String string, String string2) {
        boolean bl = false;
        NekjeScrollEditorPanel nekjeScrollEditorPanel = this.getEditorAt(n);
        if (nekjeScrollEditorPanel != null && nekjeScrollEditorPanel.saveFile(string, string2)) {
            this.wbTabs.setTitleAt(n, string2);
            nekjeScrollEditorPanel.setFFileName(string2);
            nekjeScrollEditorPanel.setFDirName(string);
            nekjeScrollEditorPanel.setEditFlag(false);
            bl = true;
        }
        return bl;
    }

    public void saveCurrentTab(String string, String string2) {
        this.saveTabAt(this.wbTabs.getSelectedIndex(), string, string2);
    }

    public boolean resaveTabAt(int n) {
        NekjeScrollEditorPanel nekjeScrollEditorPanel = this.getEditorAt(n);
        if (nekjeScrollEditorPanel.getEditFlag()) {
            // empty if block
        }
        String string = this.getFileNameAt(n);
        if (!nekjeScrollEditorPanel.getSaveFlag()) {
            String string2 = nekjeScrollEditorPanel.getClassName();
            if (string2 != null && string2.length() > 0) {
                return this.saveDialog(n, this.app.getProperties().getProperty("workingDirectory"), string2 + ".java");
            }
            return this.saveDialog(n, this.app.getProperties().getProperty("workingDirectory"), string);
        }
        return this.saveTabAt(n, this.getDirAt(n), string);
    }

    public boolean resaveCurrentTab() {
        return this.resaveTabAt(this.wbTabs.getSelectedIndex());
    }

    public void saveAs() {
        this.saveDialog(this.wbTabs.getSelectedIndex(), this.app.getProperties().getProperty("workingDirectory"), this.getCurrentFileName());
    }

    public boolean saveDialog(int n, String string, String string2) {
        boolean bl = false;
        boolean bl2 = false;
        String string3 = string2;
        String string4 = string;
        while (!bl2) {
            NekjeFileDialog nekjeFileDialog = new NekjeFileDialog(this.app, 1, string4, string3);
            string3 = nekjeFileDialog.getFile();
            string4 = nekjeFileDialog.getDirectory();
            bl2 = true;
            if (string3 == null || string3.indexOf(46) != -1) continue;
            int n2 = this.javaExtensionDialog(string3);
            if (n2 == 0) {
                string3 = string3 + ".java";
                continue;
            }
            if (n2 != 2) continue;
            bl2 = false;
        }
        if (string3 != null && (bl = this.saveTabAt(n, string4, string3))) {
            this.app.getProperties().setProperty("workingDirectory", string4);
        }
        return bl;
    }

    private int javaExtensionDialog(String string) {
        Object[] objectArray = new Object[]{"Ja", "Nein", "Abbrechen"};
        return JOptionPane.showOptionDialog(this, "Soll die Dateiendung \".java\" erg\u00e4nzt werden", "Warnung: " + string + " - fehlende Dateiendung", 1, 2, null, objectArray, objectArray[0]);
    }

    public boolean changedDialog() {
        boolean bl = true;
        if (this.getCurrentEditor().getEditFlag()) {
            bl = this.saveBeforeActionDialog("Sie haben Ver\u00e4nderungen vorgenommen. Wollen Sie diese zun\u00e4chst speichern?", this.getCurrentFileName());
        }
        return bl;
    }

    public void noJavaFile() {
        this.errorDialog("Die gew\u00e4hlte Funktion verlangt zwingend eine ge\u00f6ffnete Datei\nmit der Dateiendung .java im aktiven Karteifenster.");
    }

    public void errorDialog(String string) {
        JOptionPane.showMessageDialog(this, string, "Fehler", 0);
    }

    public boolean isJavaFile() {
        boolean bl = true;
        if (!this.getCurrentFileName().endsWith(".java")) {
            JOptionPane.showMessageDialog(this, "Speichern Sie die Datei mit der Endung .java!", "Fehler", 0);
            bl = false;
        }
        return bl;
    }

    public boolean verifyFileName() {
        String string = this.getCurrentFileName();
        String string2 = string.substring(0, string.lastIndexOf(".java"));
        if (!this.fileContainsClass(string2)) {
            this.errorDialog("Die Datei " + string + " enth\u00e4lt nicht die Klasse " + string2 + ". Gefundener Klassenname: " + this.getCurrentEditor().getClassName());
            return false;
        }
        return true;
    }

    public boolean saveBeforeActionDialog(String string, String string2) {
        boolean bl = false;
        Object[] objectArray = new Object[]{"Speichern", "Nicht Speichern", "Abbrechen"};
        int n = JOptionPane.showOptionDialog(this, string, string2, 1, 3, null, objectArray, objectArray[0]);
        if (n == 0) {
            bl = this.resaveCurrentTab();
        } else if (n == 1) {
            bl = true;
        }
        return bl;
    }

    public String getParameterDialog() {
        return JOptionPane.showInputDialog(this, (Object)"Welche Parameter wollen Sie an das Programm \u00fcbergeben?");
    }

    public String getCurrentFileName() {
        return this.getCurrentEditor().getFFileName();
    }

    public String getCurrentFile() {
        NekjeScrollEditorPanel nekjeScrollEditorPanel = this.getCurrentEditor();
        return nekjeScrollEditorPanel.getFDirName() + nekjeScrollEditorPanel.getFFileName();
    }

    public String getCurrentDir() {
        return this.getCurrentEditor().getFDirName();
    }

    public String getFileAt(int n) {
        NekjeScrollEditorPanel nekjeScrollEditorPanel = this.getEditorAt(n);
        return nekjeScrollEditorPanel.getFDirName() + nekjeScrollEditorPanel.getFFileName();
    }

    public String getDirAt(int n) {
        NekjeScrollEditorPanel nekjeScrollEditorPanel = this.getEditorAt(n);
        return nekjeScrollEditorPanel.getFDirName();
    }

    public String getFileNameAt(int n) {
        NekjeScrollEditorPanel nekjeScrollEditorPanel = this.getEditorAt(n);
        return nekjeScrollEditorPanel.getFFileName();
    }

    public NekjeDocument getCurrentDocument() {
        return this.getCurrentEditor().getDocument();
    }

    public NekjeConsole getConsole() {
        return this.app.getConsole();
    }

    public String getClassName() {
        return this.getCurrentEditor().getClassName();
    }

    public boolean fileContainsClass(String string) {
        return this.getCurrentEditor().fileContainsClass(string);
    }

    public void insertBlock(String string, int n) {
        this.getCurrentEditor().insertBlock(string, n);
    }

    public void processCommand(final String string) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    Process process = Runtime.getRuntime().exec(string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    public void createHTML(String string, String string2) {
        String string3 = "<html>\n<!-- HTML-Testdatei fuer Java-Applet " + string2 + "-->\n" + "<body>\n<applet code=\"" + string2 + ".class\" " + "width=\"400\" height=\"200\">\n</applet>\n</body>\n</html>\n";
        String string4 = string2 + ".htm";
        int n = this.wbTabs.getSelectedIndex();
        NekjeScrollEditorPanel nekjeScrollEditorPanel = this.getCurrentEditor();
        this.wbTabs.setTitleAt(n, string4);
        nekjeScrollEditorPanel.setFFileName(string4);
        nekjeScrollEditorPanel.setFDirName(string);
        this.getCurrentEditor().insertBlock(string3, 0);
    }

    public boolean loadIndentPlugin() {
        boolean bl = false;
        String string = this.app.getProperties().getProperty("indentPluginURL");
        String string2 = this.app.getProperties().getProperty("indentPluginClass");
        if (string != null && string2 != null) {
            try {
                String string3 = "";
                try {
                    string3 = string2.substring(string2.lastIndexOf(46) + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    string3 = string2;
                }
                if (string3.length() > 0) {
                    String string4 = string3 + "PluginWrapper";
                    Class<?> clazz = Class.forName(string4);
                    this.indentObject = (NekjeIndentClass)clazz.newInstance();
                    this.indentObject.setURL(string);
                    this.indentObject.setClassName(string2);
                    this.indentObject.loadPlugin();
                    bl = this.indentObject.isValid();
                }
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
                bl = false;
            }
        }
        if (!bl && this.indentObject != null) {
            this.indentObject = null;
        }
        return bl;
    }

    public void indent() {
        if (this.indentObject != null) {
            try {
                String string = this.getCurrentEditor().getText();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.indentObject.parse(byteArrayInputStream, byteArrayOutputStream);
                string = byteArrayOutputStream.toString();
                this.getCurrentEditor().setText(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public NekjeIndentClass getIndentPlugin() {
        return this.indentObject;
    }
}

