/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.util.Properties;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class NekjeTextArea
extends JEditTextArea {
    final UndoManager undo = new UndoManager();

    public NekjeTextArea(TextAreaDefaults textAreaDefaults, Properties properties) {
        super(textAreaDefaults);
        try {
            int n = Integer.parseInt(properties.getProperty("nekjeFontsize"));
            int n2 = 0;
            if (properties.getProperty("nekjeFonttype").equals("BOLD")) {
                n2 = 1;
            } else if (properties.getProperty("nekjeFonttype").equals("ITALIC")) {
                n2 = 2;
            }
            this.getPainter().setFont(new Font(properties.getProperty("nekjeFont"), n2, n));
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Fehler beim Setzen des Schriftfonts: " + numberFormatException.getMessage());
        }
        SyntaxDocument syntaxDocument = this.getDocument();
        syntaxDocument.addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                NekjeTextArea.this.undo.addEdit(undoableEditEvent.getEdit());
            }
        });
    }

    public void undo() {
        try {
            if (this.undo.canUndo()) {
                this.undo.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void redo() {
        try {
            if (this.undo.canRedo()) {
                this.undo.redo();
            }
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }
}

