/*
 * Decompiled with CFR 0.152.
 */
import gnu.regexp.RE;
import gnu.regexp.REMatch;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;

public class NekjeScrollEditorPanel
extends JPanel
implements DocumentListener {
    protected NekjeTextArea ta;
    protected TextAreaDefaults def;
    protected JPanel statusPanel;
    protected JLabel rcLabel;
    protected JLabel statusLabel;
    private NekjeWBPanel wbRef;
    private String fName;
    private String fDir;
    private boolean editFlag = false;
    private boolean saveFlag = false;
    private RE re = null;
    private final String classSearchString = "public\\s+((static|abstract)\\s+)*((class|interface)\\s+)\\w+";

    public NekjeScrollEditorPanel(NekjeWBPanel nekjeWBPanel, String string, String string2, boolean bl) {
        this.wbRef = nekjeWBPanel;
        this.fName = string2;
        this.fDir = string;
        this.ta = new NekjeTextArea(this.getNekjeTextAreaDefaults(), nekjeWBPanel.getProperties());
        if (!bl) {
            this.readFile();
        } else {
            this.setSaveFlag(false);
        }
        this.statusPanel = new JPanel();
        this.rcLabel = new JLabel(" Zeile:    1 Position:   1 ");
        this.statusLabel = new JLabel();
        this.statusPanel.setLayout(new BorderLayout());
        this.statusPanel.add((Component)this.rcLabel, "West");
        this.statusPanel.add((Component)this.statusLabel, "East");
        this.setLayout(new BorderLayout());
        this.ta.add(JEditTextArea.LEFT_OF_SCROLLBAR, this.statusPanel);
        this.add((Component)this.ta, "Center");
        this.getDocument().addDocumentListener(this);
        this.ta.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                Element element = NekjeScrollEditorPanel.this.def.document.getDefaultRootElement();
                int n = NekjeScrollEditorPanel.this.ta.getCaretPosition();
                int n2 = NekjeScrollEditorPanel.this.ta.getCaretLine();
                Element element2 = element.getElement(n2);
                int n3 = element2.getStartOffset();
                NekjeScrollEditorPanel.this.rcLabel.setText(" Zeile: " + (n2 + 1) + " Position: " + (n - n3 + 1) + " ");
            }
        });
        try {
            this.re = new RE((Object)"public\\s+((static|abstract)\\s+)*((class|interface)\\s+)\\w+");
        }
        catch (Exception exception) {
            this.re = null;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (!this.getEditFlag()) {
            this.setEditFlag(true);
            this.wbRef.changedUpdate();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    private TextAreaDefaults getNekjeTextAreaDefaults() {
        this.def = new TextAreaDefaults();
        this.def.inputHandler = new DefaultInputHandler();
        this.def.inputHandler.addDefaultKeyBindings();
        this.def.document = new NekjeDocument();
        this.def.editable = true;
        this.def.caretVisible = true;
        this.def.caretBlinks = true;
        this.def.electricScroll = 3;
        this.def.cols = 80;
        this.def.rows = 25;
        this.def.styles = this.setNekjeSyntaxStyles();
        this.def.caretColor = Color.red;
        this.def.selectionColor = new Color(0xCCCCFF);
        this.def.lineHighlightColor = new Color(0xE0E0E0);
        this.def.lineHighlight = true;
        this.def.bracketHighlightColor = Color.black;
        this.def.bracketHighlight = true;
        this.def.eolMarkerColor = new Color(39321);
        this.def.eolMarkers = true;
        this.def.paintInvalid = true;
        return this.def;
    }

    public SyntaxStyle[] setNekjeSyntaxStyles() {
        SyntaxStyle[] syntaxStyleArray = new SyntaxStyle[11];
        syntaxStyleArray[1] = new SyntaxStyle(Color.lightGray, true, false);
        syntaxStyleArray[2] = new SyntaxStyle(new Color(0x990033), true, false);
        syntaxStyleArray[6] = new SyntaxStyle(Color.blue, false, true);
        syntaxStyleArray[7] = new SyntaxStyle(Color.magenta, false, false);
        syntaxStyleArray[8] = new SyntaxStyle(Color.blue, false, true);
        syntaxStyleArray[3] = new SyntaxStyle(new Color(6619289), false, false);
        syntaxStyleArray[4] = new SyntaxStyle(new Color(6619289), false, true);
        syntaxStyleArray[5] = new SyntaxStyle(new Color(0x990033), false, true);
        syntaxStyleArray[9] = new SyntaxStyle(Color.black, false, true);
        syntaxStyleArray[10] = new SyntaxStyle(Color.red, false, true);
        return syntaxStyleArray;
    }

    public NekjeTextArea getTextArea() {
        return this.ta;
    }

    public void activateEditor() {
        this.ta.requestFocus();
    }

    public void setFirstLine(int n) {
        this.ta.setCaretPosition(this.ta.getLineStartOffset(n));
    }

    private boolean readFile() {
        boolean bl = false;
        if (this.ta != null && this.fName != null && this.fName.length() > 0) {
            try {
                int n;
                String string = (this.fDir != null ? this.fDir : ".") + this.fName;
                FileReader fileReader = new FileReader(new File(string));
                char[] cArray = new char[8000];
                StringBuffer stringBuffer = new StringBuffer(8000);
                do {
                    if ((n = fileReader.read(cArray, 0, cArray.length)) <= 0) continue;
                    stringBuffer.append(cArray, 0, n);
                } while (n != -1);
                this.ta.setText(stringBuffer.toString());
                fileReader.close();
                this.ta.setCaretPosition(0);
                this.setTokenMarker(this.ta, this.fName);
                this.setSaveFlag(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean saveFile(String string, String string2) {
        boolean bl = false;
        String string3 = this.ta.getText();
        try {
            FileWriter fileWriter = new FileWriter(new File(string + string2));
            fileWriter.write(string3, 0, string3.length());
            fileWriter.close();
            bl = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setSaveFlag(true);
        if (this.ta.getTokenMarker() == null) {
            this.setTokenMarker(this.ta, string2);
        }
        return bl;
    }

    private void setTokenMarker(NekjeTextArea nekjeTextArea, String string) {
        if (string.endsWith(".java")) {
            nekjeTextArea.setTokenMarker(new JavaTokenMarker());
        } else if (string.endsWith(".htm") || string.endsWith(".html")) {
            nekjeTextArea.setTokenMarker(new HTMLTokenMarker());
        }
    }

    public String getText() {
        return this.ta.getText();
    }

    public void setText(String string) {
        this.ta.setText(string);
    }

    public String getCaretText() {
        NekjeDocument nekjeDocument = this.getDocument();
        return nekjeDocument.getCurrentToken(this.ta.getCaretPosition());
    }

    public void setFFileName(String string) {
        this.fName = string;
    }

    public String getFFileName() {
        return this.fName;
    }

    public void setFDirName(String string) {
        this.fDir = string;
    }

    public String getFDirName() {
        return this.fDir;
    }

    public void setEditFlag(boolean bl) {
        this.editFlag = bl;
    }

    public boolean getEditFlag() {
        return this.editFlag;
    }

    public void setSaveFlag(boolean bl) {
        this.saveFlag = bl;
    }

    public boolean getSaveFlag() {
        return this.saveFlag;
    }

    public NekjeDocument getDocument() {
        return (NekjeDocument)this.def.document;
    }

    public String getClassName() {
        String string;
        REMatch rEMatch;
        String string2 = null;
        if (this.re != null && (rEMatch = this.re.getMatch((Object)(string = this.ta.getText()))) != null) {
            String string3 = rEMatch.toString();
            string2 = string3.substring(string3.lastIndexOf(32));
            string2 = string2.trim();
        }
        return string2;
    }

    public boolean fileContainsClass(String string) {
        return string.equals(this.getClassName());
    }

    public void insertBlock(String string, int n) {
        int n2 = this.ta.getCaretPosition();
        NekjeDocument nekjeDocument = this.getDocument();
        int n3 = nekjeDocument.insertBlock(string, n2, n);
        this.ta.setCaretPosition(n3);
    }
}

