/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class NekjeReference
extends JFrame
implements HyperlinkListener {
    protected JFrame parentFrame;
    protected KlassenReferenz reference = new KlassenReferenz();
    protected JTextField eingabeFeld;
    protected JButton sucheButton;
    protected JEditorPane ausgabeArea;
    protected String apiDocPath;
    protected String refSrc;
    protected Properties refProps;
    protected Properties sysProps;
    private static final String[] tb = new String[]{"<td valign=\"top\" nowrap><font size=2>", "<td><font size=2 color=\"#0000ff\">", "</font></td>"};

    public NekjeReference() {
        this.setTitle("Nekje-Referenz");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Suchbegriff: "));
        this.eingabeFeld = new JTextField(20);
        this.eingabeFeld.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NekjeReference.this.processAction(NekjeReference.this.eingabeFeld.getText());
            }
        });
        jPanel.add(this.eingabeFeld);
        this.sucheButton = new JButton("Suchen");
        this.sucheButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = NekjeReference.this.ausgabeArea.getSelectedText();
                if (string == null || string.length() == 0) {
                    string = NekjeReference.this.eingabeFeld.getText();
                }
                NekjeReference.this.processAction(string);
            }
        });
        jPanel.add(this.sucheButton);
        this.getContentPane().add((Component)jPanel, "North");
        this.ausgabeArea = new JEditorPane("text/html", "");
        this.ausgabeArea.setEditable(false);
        this.ausgabeArea.addHyperlinkListener(this);
        this.setAusgabeText("<html><body>Geben Sie den Namen einer Klasse im Eingabefeld ein!</body></html>");
        JScrollPane jScrollPane = new JScrollPane(this.ausgabeArea);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (NekjeReference.this.parentFrame != null) {
                    ((Component)NekjeReference.this).setVisible(false);
                } else {
                    System.exit(0);
                }
            }
        });
        this.sysProps = System.getProperties();
    }

    public void setParent(JFrame jFrame) {
        this.parentFrame = jFrame;
    }

    public void setClassPath(String string) {
        this.reference.setClassPath(string);
    }

    public void setReferenceSource(String string) {
        this.refSrc = string;
        this.refProps = new Properties();
        this.loadProperties(this.refProps, string);
        this.apiDocPath = this.refProps.getProperty("apiDocs");
        this.reference.setApiDocPath(this.apiDocPath);
    }

    protected void loadProperties(Properties properties, String string) {
        try {
            URL uRL = new URL(string);
            properties.load((InputStream)uRL.getContent());
        }
        catch (Exception exception) {
            try {
                properties.load(new FileInputStream(string));
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        try {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.eingabeFeld.setText("");
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                } else {
                    try {
                        jEditorPane.setPage(hyperlinkEvent.getURL());
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void processAction(String string) {
        this.eingabeFeld.setText("");
        if (string != null) {
            if (string.endsWith("\n")) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                string = stringBuffer.toString();
            }
            if (string.length() > 0) {
                this.getReference(string);
                this.eingabeFeld.setText(string);
            } else {
                this.eingabeFeld.setText("Kein Suchbegriff definiert...");
            }
        }
    }

    public void setAusgabeText(String string) {
        this.ausgabeArea.setContentType("text/html");
        this.ausgabeArea.setText(string);
        this.ausgabeArea.setCaretPosition(0);
    }

    public void getReference(String string) {
        boolean bl = false;
        String string2 = null;
        this.eingabeFeld.setText(string);
        if (this.refProps != null && (string2 = this.refProps.getProperty(string)) != null) {
            try {
                this.ausgabeArea.setContentType("text/plain");
                this.ausgabeArea.setPage(new URL(string2));
            }
            catch (Exception exception) {
                this.setAusgabeText("Fehler beim Laden von " + string2 + "(" + exception.toString() + ")");
            }
            bl = true;
        }
        if (!bl && this.sysProps != null) {
            String string3 = "";
            if (string.equals("about")) {
                Enumeration<?> enumeration = this.sysProps.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    string3 = string3 + "<tr>" + tb[0] + string4 + ":" + tb[2] + tb[1] + this.sysProps.getProperty(string4) + tb[2] + "</tr>";
                }
            } else if (string.indexOf(46) != -1) {
                Enumeration<?> enumeration = this.sysProps.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string5 = (String)enumeration.nextElement();
                    if (string5.indexOf(string) == -1) continue;
                    string3 = string3 + "<tr>" + tb[0] + string5 + ":" + tb[2] + tb[1] + this.sysProps.getProperty(string5) + tb[2] + "</tr>";
                }
            }
            if (string3.length() > 0) {
                this.showSysProperties(string3);
                bl = true;
            }
        }
        if (!bl) {
            this.setAusgabeText("<html><body>Bitte etwas Geduld ...</body></html>");
            this.setAusgabeText(this.reference.getHTMLReferenz(string));
        }
    }

    private void showSysProperties(String string) {
        String string2 = "<html><body><table>" + string + "</table></font></body></html>";
        this.setAusgabeText(string2);
    }

    public static void main(String[] stringArray) throws ClassNotFoundException {
        NekjeReference nekjeReference = new NekjeReference();
        ((Component)nekjeReference).setSize(800, 600);
        ((Component)nekjeReference).setVisible(true);
    }
}

