/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class NekjeDocumentPainter
extends JComponent
implements Printable {
    protected Document doc;
    protected PageFormat pFormat;
    protected ArrayList pages;
    protected Font font;
    protected boolean rowNumbers;
    private int currentPage;
    private Dimension mPreferredSize;

    public NekjeDocumentPainter(Document document, PageFormat pageFormat, boolean bl) {
        this.doc = document;
        this.pFormat = pageFormat;
        this.rowNumbers = bl;
        this.font = new Font("Monospaced", 0, 10);
        this.pages = this.repaginate(pageFormat);
    }

    public Dimension getPreferredSize() {
        return this.mPreferredSize;
    }

    public int calculatePageCount() {
        if (this.pages == null) {
            this.pages = this.repaginate(this.pFormat);
        }
        return this.pages.size();
    }

    public ArrayList repaginate(PageFormat pageFormat) {
        int n = (int)pageFormat.getImageableHeight();
        int n2 = this.font.getSize();
        Element element = this.doc.getDefaultRootElement();
        int n3 = element.getElementCount();
        ArrayList arrayList = new ArrayList();
        int n4 = 0;
        ArrayList<CodeLine> arrayList2 = new ArrayList<CodeLine>();
        int n5 = 0;
        while (n5 < n3) {
            Element element2 = element.getElement(n5);
            try {
                CodeLine codeLine = new CodeLine(this.doc.getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset()), n5 + 1);
                if (n4 + n2 > n) {
                    arrayList.add(arrayList2);
                    arrayList2 = new ArrayList();
                    n4 = 0;
                }
                arrayList2.add(codeLine);
                n4 += n2;
            }
            catch (BadLocationException badLocationException) {
                break;
            }
            ++n5;
        }
        arrayList.add(arrayList2);
        return arrayList;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (this.pFormat != pageFormat) {
            this.pFormat = pageFormat;
            this.pages = this.repaginate(pageFormat);
        }
        if (n >= this.pages.size()) {
            return 1;
        }
        this.currentPage = n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.mPreferredSize = new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        this.paintComponent(graphics2D);
        return 0;
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth("00000: ");
        int n2 = this.font.getSize();
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, this.mPreferredSize.width, this.mPreferredSize.height);
        graphics2D.setPaint(Color.white);
        graphics2D.fill(float_);
        ArrayList arrayList = (ArrayList)this.pages.get(this.currentPage);
        Iterator iterator = ((AbstractList)arrayList).iterator();
        graphics2D.setPaint(Color.black);
        graphics2D.setFont(this.font);
        while (iterator.hasNext()) {
            int n3 = 0;
            CodeLine codeLine = (CodeLine)iterator.next();
            String string = this.trimLine(codeLine.getLine());
            if (this.rowNumbers) {
                graphics2D.drawString(codeLine.getNumLine() + ":", n3, n2);
                n3 = n + 10;
            }
            graphics2D.drawString(string, n3, n2);
            n2 += this.font.getSize();
        }
    }

    private String trimLine(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\t') {
                if (n > n2) {
                    stringBuffer.append(string.substring(n2, n));
                }
                stringBuffer.append("    ");
                n2 = n + 1;
            }
            ++n;
        }
        if (n > n2) {
            stringBuffer.append(string.substring(n2, n));
        }
        n = stringBuffer.length() - 1;
        while (n >= 0 && stringBuffer.charAt(n) < ' ') {
            --n;
        }
        return stringBuffer.substring(0, n + 1);
    }

    class CodeLine {
        private String line;
        private int numLine;

        public CodeLine(String string, int n) {
            this.line = string;
            this.numLine = n;
        }

        public String getLine() {
            return this.line;
        }

        public int getNumLine() {
            return this.numLine;
        }
    }
}

