/*
 * Decompiled with CFR 0.152.
 */
import gnu.regexp.RE;
import gnu.regexp.REMatch;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class NekjeConsole
extends JFrame
implements ActionListener {
    protected JTextArea textArea;
    protected Font textFont;
    protected Font font;
    protected Nekje pp;
    protected Document doc;
    protected String classpath = ".";
    protected String warning = "";
    private RE re = null;
    private final String searchString = "\\w+\\.\\w+:\\d+:";

    public NekjeConsole(Nekje nekje) {
        super("Nekje Console");
        this.pp = nekje;
        this.getContentPane().setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(false);
        this.textFont = new Font("Monospaced", 0, 12);
        this.textArea.setFont(this.textFont);
        this.textArea.setEditable(false);
        this.doc = this.textArea.getDocument();
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Schlie\u00dfen");
        jButton.setActionCommand("Close");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Drucken");
        jButton2.setActionCommand("Print");
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("Gehe zu");
        jButton3.setActionCommand("Goto");
        jButton3.addActionListener(this);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)NekjeConsole.this).setVisible(false);
            }
        });
        try {
            this.re = new RE((Object)"\\w+\\.\\w+:\\d+:");
        }
        catch (Exception exception) {
            this.re = null;
        }
        try {
            ((Component)this).setSize(Integer.parseInt(this.pp.getProperties().getProperty("nekjeConsoleWidth")), Integer.parseInt(this.pp.getProperties().getProperty("nekjeConsoleHeight")));
            ((Component)this).setLocation(Integer.parseInt(this.pp.getProperties().getProperty("nekjeConsoleX")), Integer.parseInt(this.pp.getProperties().getProperty("nekjeConsoleY")));
        }
        catch (Exception exception) {
            ((Component)this).setSize(600, 400);
            ((Component)this).setLocation(this.pp.getX() + 50, this.pp.getY() + 100);
        }
        ((Component)this).setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block10: {
            String string = actionEvent.getActionCommand();
            if (string.equals("Print")) {
                this.printConsoleText();
            } else if (string.equals("Close")) {
                ((Component)this).setVisible(false);
            } else if (string.equals("Goto")) {
                try {
                    String string2 = this.textArea.getSelectedText();
                    REMatch rEMatch = this.re.getMatch((Object)string2);
                    if (rEMatch == null) break block10;
                    String string3 = rEMatch.toString();
                    int n = string3.indexOf(58);
                    String string4 = string3.substring(0, n);
                    String string5 = string3.substring(n + 1, string3.length() - 1);
                    try {
                        if (this.pp.getWBPanel().activateTab(string4)) {
                            this.pp.getWBPanel().gotoLine(Integer.parseInt(string5) - 1);
                            System.err.println("Editor gefunden");
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void processSystemCommand(final String string) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    Process process = Runtime.getRuntime().exec("c:\\windows\\command.com " + string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    public void processCommand(final String string) {
        Thread thread = new Thread(){

            public void run() {
                NekjeConsole.this.textArea.setText("");
                ((Component)NekjeConsole.this).setVisible(true);
                NekjeConsole.this.textArea.append(NekjeConsole.this.warning);
                NekjeConsole.this.textArea.append("[BEFEHL:] " + string + "\n\n");
                String string2 = "";
                try {
                    Process process = Runtime.getRuntime().exec(string);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    boolean bl = false;
                    NekjeConsole.this.textArea.append("[FEHLER:] ");
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (!bl) {
                            bl = true;
                        }
                        NekjeConsole.this.textArea.append("\n\t" + string2);
                    }
                    if (!bl) {
                        NekjeConsole.this.textArea.append("Keine Fehler gefunden.\n");
                    }
                    bufferedReader.close();
                    NekjeConsole.this.textArea.append("\n[STDOUT:]\n");
                    BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    int n = 0;
                    while ((string2 = bufferedReader2.readLine()) != null && n < 4) {
                        NekjeConsole.this.textArea.append("\t" + string2 + "\n");
                    }
                    bufferedReader2.close();
                    NekjeConsole.this.textArea.append("\n[EXIT-WERT:] " + process.exitValue() + "\n");
                }
                catch (IOException iOException) {
                    NekjeConsole.this.textArea.append(iOException.toString());
                }
            }
        };
        thread.start();
    }

    synchronized void printConsoleText() {
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        Book book = new Book();
        NekjeDocumentPainter nekjeDocumentPainter = new NekjeDocumentPainter(this.doc, pageFormat, false);
        int n = nekjeDocumentPainter.calculatePageCount();
        book.append(nekjeDocumentPainter, pageFormat, n);
        printerJob.setPageable(book);
        if (printerJob.printDialog()) {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        printerJob.print();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        }
    }

    public void compileJavaApp(String string, String string2, String string3) {
        String string4 = "";
        String string5 = "";
        String string6 = this.pp.getProperties().getProperty("classpath");
        String string7 = this.pp.getProperties().getProperty("pathSeparator");
        String string8 = this.pp.getProperties().getProperty("outputDirectory");
        this.warning = "";
        if (string7 == null) {
            string7 = ";";
        }
        string4 = string6 != null && string6.length() > 0 ? string6 + string7 + string : string;
        string5 = string8 != null && string8.length() > 0 ? string8 : string2;
        this.processCommand(this.pp.getProperties().getProperty("javacExe") + " -classpath " + string4 + " -d " + string5 + " " + string + string3);
    }

    public void runJavaApp(String string, String string2, String string3, boolean bl) {
        String string4 = string2;
        String string5 = string;
        String string6 = string;
        String string7 = this.pp.getProperties().getProperty("classpath");
        String string8 = this.pp.getProperties().getProperty("pathSeparator");
        String string9 = this.pp.getProperties().getProperty("outputDirectory");
        this.warning = "Hinweis: Umfangreiche DOS-Konsolenausgaben fuehren unter Windows 95/98\nleider zum Haengen von Prozessen (siehe hierzu Nekje-Hilfe)\n\n";
        if (string8 == null) {
            string8 = ";";
        }
        string6 = string7 != null && string7.length() > 0 ? string7 + string8 + string : string;
        if (string9 != null && !string9.equals(string)) {
            string6 = string6 + string8 + string9;
        }
        if (string4.endsWith(".java") || string4.endsWith(".class")) {
            string4 = string4.substring(0, string4.lastIndexOf(46));
            if (string3 != null) {
                string4 = string4 + " " + string3;
            }
            String string10 = this.pp.getProperties().getProperty("javaExe") + " -classpath " + string6 + " " + string4;
            if (!bl) {
                this.processCommand(string10);
            } else {
                this.processSystemCommand(string10);
            }
        } else if (string4.endsWith(".htm") || string4.endsWith(".html")) {
            if (string3 != null) {
                string4 = string4 + " " + string3;
            }
            System.setProperty("user.dir", string5);
            this.processCommand(this.pp.getProperties().getProperty("appletviewerExe") + " file:///" + string5 + string4);
        }
    }

    public void showDocument(final Document document) {
        final Element element = document.getDefaultRootElement();
        final int n = element.getElementCount();
        Thread thread = new Thread(){

            public void run() {
                Object object;
                NekjeConsole.this.textArea.setText("");
                ((Component)NekjeConsole.this).setVisible(true);
                int n5 = 0;
                while (n5 < n) {
                    object = element.getElement(n5);
                    int n2 = object.getStartOffset();
                    int n3 = object.getEndOffset();
                    NekjeConsole.this.textArea.append("\nElement (" + n2 + " " + n3 + ") " + n5 + ": ");
                    try {
                        int n4 = n3 - n2;
                        String string = document.getText(n2, n4);
                        NekjeConsole.this.textArea.append(string);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    ++n5;
                }
                if (NekjeConsole.this.pp.getProperties() != null) {
                    object = NekjeConsole.this.pp.getProperties().getProperty("javaExe");
                    NekjeConsole.this.textArea.append("Property javaExe = " + (String)object + "\n");
                } else {
                    NekjeConsole.this.textArea.append("Sorry. Keine Properties gefunden.\n");
                }
            }
        };
        thread.start();
    }

    public void setErrorColor() {
        this.textArea.setForeground(Color.red);
    }

    public void setStandardColor() {
        this.textArea.setForeground(Color.black);
    }

    public void appendText(String string) {
        this.textArea.append(string);
    }
}

