/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Nekje
extends JFrame {
    protected NekjeWBPanel wbPanel;
    protected NekjeMenuBar nekjeMenuBar;
    protected NekjeToolBar nekjeToolBar;
    protected NekjeConsole nekjeConsole;
    protected NekjeCodeSnippets nekjeCodeSnippets;
    protected NekjeReference nekjeReference;
    public Properties props;
    private final String version = "Nekje Version 020709";

    public Nekje(String string) {
        super("Nekje");
        SplashScreen splashScreen = new SplashScreen("images/nekje.png");
        ((Component)splashScreen).setVisible(true);
        splashScreen.setText("Nekje Version 020709", 5);
        splashScreen.setText("Lade Look-And-Feel", 20);
        this.setLookAndFeel();
        this.setAppIcon();
        splashScreen.setText("Lade Eigenschaften", 35);
        this.props = this.initProperties(string);
        splashScreen.setText("Lade Referenz-Browser", 50);
        this.initReferenceBrowser();
        splashScreen.setText("Lade Quelltext-Bausteine", 70);
        this.initCodeSnippets();
        splashScreen.setText("Lade GUI-Elemente", 90);
        this.nekjeConsole = new NekjeConsole(this);
        this.wbPanel = new NekjeWBPanel(this);
        this.nekjeMenuBar = new NekjeMenuBar(this.wbPanel);
        this.nekjeToolBar = new NekjeToolBar(this.wbPanel);
        this.setJMenuBar(this.nekjeMenuBar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.nekjeToolBar, "North");
        this.getContentPane().add((Component)this.wbPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Nekje.this.wbPanel.actionSet.actionExit.actionPerformed(null);
            }
        });
        ((Component)splashScreen).setVisible(false);
        splashScreen.dispose();
    }

    protected void initReferenceBrowser() {
        String string = this.getProperties().getProperty("referenceData");
        if (string != null) {
            this.nekjeReference = new NekjeReference();
            this.nekjeReference.setParent(this);
            try {
                int n = Integer.parseInt(this.props.getProperty("nekjeReferenceWidth"));
                int n2 = Integer.parseInt(this.props.getProperty("nekjeReferenceHeight"));
                int n3 = Integer.parseInt(this.props.getProperty("nekjeReferenceX"));
                int n4 = Integer.parseInt(this.props.getProperty("nekjeReferenceY"));
                ((Component)this.nekjeReference).setSize(n, n2);
                ((Component)this.nekjeReference).setLocation(n3, n4);
            }
            catch (Exception exception) {
                ((Component)this.nekjeReference).setSize(400, 400);
                ((Component)this.nekjeReference).setLocation(0, 0);
            }
            this.nekjeReference.setReferenceSource(string);
            this.nekjeReference.setClassPath(System.getProperty("java.class.path"));
        }
    }

    public String getVersion() {
        return "Nekje Version 020709";
    }

    public NekjeReference getReferenceBrowser() {
        return this.nekjeReference;
    }

    public void initCodeSnippets() {
        String string = this.getProperties().getProperty("codeSnippets");
        if (string != null) {
            this.nekjeCodeSnippets = new NekjeCodeSnippets(string);
        }
    }

    public NekjeCodeSnippets getCodeSnippets() {
        return this.nekjeCodeSnippets;
    }

    public NekjeConsole getConsole() {
        return this.nekjeConsole;
    }

    public NekjeWBPanel getWBPanel() {
        return this.wbPanel;
    }

    private void setLookAndFeel() {
        String string = null;
        if (this.props != null) {
            string = this.props.getProperty("plaf");
        }
        if (string == null) {
            string = UIManager.getSystemLookAndFeelClassName();
        }
        if (string != null) {
            try {
                UIManager.setLookAndFeel(string);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private void setAppIcon() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("images/nekje_icon.gif"));
        ((Frame)this).setIconImage(imageIcon.getImage());
    }

    private Properties initProperties(String string) {
        Properties properties = new Properties();
        this.setDefaultProperties(properties);
        this.loadProperties(properties, string);
        this.setSystemClassPath(properties);
        return properties;
    }

    private void setSystemClassPath(Properties properties) {
        String string = properties.getProperty("classpath");
        String string2 = properties.getProperty("workingDirectory");
        String string3 = properties.getProperty("outputDirectory");
        String string4 = properties.getProperty("pathSeparator");
        String string5 = System.getProperty("java.class.path");
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string4);
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken();
                if (string5.indexOf(string6) != -1) continue;
                string5 = string6 + string4 + string5;
            }
        }
        if (!string5.equals(System.getProperty("java.class.path"))) {
            System.setProperty("java.class.path", string5);
        }
    }

    private void setDefaultProperties(Properties properties) {
        properties.setProperty("pathSeparator", System.getProperty("path.separator"));
        properties.setProperty("lineBreak", System.getProperty("line.separator"));
        properties.setProperty("workingDirectory", System.getProperty("user.dir"));
        properties.setProperty("outputDirectory", "");
        properties.setProperty("classpath", "");
        properties.setProperty("nekjeFont", "Monospaced");
        properties.setProperty("nekjeFontsize", "14");
        properties.setProperty("nekjeFonttype", "BOLD");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        properties.setProperty("nekjeScreenWidth", "" + (int)dimension.getWidth());
        properties.setProperty("nekjeScreenHeight", "" + ((int)(dimension.getHeight() * 7.0 / 10.0) - 35));
        properties.setProperty("nekjeScreenX", "0");
        properties.setProperty("nekjeScreenY", "0");
        properties.setProperty("nekjeConsoleWidth", "" + (int)dimension.getWidth());
        properties.setProperty("nekjeConsoleHeight", "" + (int)(dimension.getHeight() * 3.0 / 10.0));
        properties.setProperty("nekjeConsoleX", "0");
        properties.setProperty("nekjeConsoleY", "" + ((int)(dimension.getHeight() * 7.0 / 10.0) - 35));
        properties.setProperty("nekjeReferenceWidth", "" + (int)(dimension.getWidth() * 4.0 / 10.0));
        properties.setProperty("nekjeReferenceHeight", "" + ((int)(dimension.getHeight() * 7.0 / 10.0) - 40));
        properties.setProperty("nekjeReferenceX", "" + (int)(dimension.getWidth() - dimension.getWidth() * 4.0 / 10.0));
        properties.setProperty("nekjeReferenceY", "40");
    }

    public void loadProperties(Properties properties, String string) {
        try {
            URL uRL = new URL(string);
            properties.load((InputStream)uRL.getContent());
        }
        catch (Exception exception) {
            try {
                properties.load(new FileInputStream(string));
            }
            catch (Exception exception2) {
                System.out.println(exception2.toString());
            }
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public void run() {
        try {
            ((Component)this).setSize(Integer.parseInt(this.props.getProperty("nekjeScreenWidth")), Integer.parseInt(this.props.getProperty("nekjeScreenHeight")));
            ((Component)this).setLocation(Integer.parseInt(this.props.getProperty("nekjeScreenX")), Integer.parseInt(this.props.getProperty("nekjeScreenY")));
        }
        catch (Exception exception) {
            ((Component)this).setSize(600, 400);
            ((Component)this).setLocation(10, 10);
        }
        ((Component)this).setVisible(true);
    }

    public static void main(String[] stringArray) {
        String string = "nekje.cfg";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        Nekje nekje = new Nekje(string);
        nekje.run();
    }
}

