import java.util.*;

public class PersonenSteckbrief extends Person {

	protected String Wohnort;
	protected String PLZ;
	protected String Strasse;
	protected String Geschlecht;
	protected int gyy, gmm, gdd;

	// Konstruktor
	public PersonenSteckbrief() {
	}
	
	public void setWohnort( String ort ) {
		Wohnort = ort;
	}
	
	public void setPLZ( String postleitzahl ) {
		PLZ = postleitzahl;
	}
	public void setStrasse( String st ) {
		Strasse = st;
	}
	public void setGeschlecht( String g ) {
		Geschlecht = g;
	}
	public void setGeburtsdatum( int y, int m, int d ) {
		gyy = y;
		gmm = m;
		gdd = d;
	}
	
	protected int berechneAlter() {
	
		Date heute = new Date();
		GregorianCalendar gk = new GregorianCalendar();
		gk.setTime(heute);
		int hyy = gk.get(Calendar.YEAR);
		int hmm = gk.get(Calendar.MONTH);
		int hdd = gk.get(Calendar.DAY_OF_MONTH);
		
		int alter = hyy - gyy;
		
		if( hmm < gmm )
			alter--;
		else if( hmm == gmm ) {
			if( hdd < gdd )
				alter--;
		}
				
		return( alter );		
	}
	
	public void printSteckbrief() {
	
		super.printName();
		System.out.print("\n");	
		System.out.println( Strasse + "\n" + PLZ + " " + Wohnort +
			"\nGeschlecht " + Geschlecht + "\ngeb. " +
			gdd + "." + gmm + "." + gyy + "\nAlter: " +
			berechneAlter() );
	}
	
}












