import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;
import java.math.BigDecimal;

public class EuroRechner extends Applet implements ActionListener {

	private TextField ursprungsBetrag;
	private Label euroBetrag;
	private Button rechnenButton;
	 
	public void init() {
	
		setLayout( new BorderLayout() );
		
		Panel p = new Panel( new GridLayout(2,2) );
		
		p.add( new Label("DM-Betrag:") );
		ursprungsBetrag = new TextField(20);
		p.add(ursprungsBetrag);
		
		p.add( new Label("Euro-Betrag:") );
		euroBetrag = new Label();
		p.add(euroBetrag);
		
		add(p, BorderLayout.NORTH );	
	
		rechnenButton = new Button("DM -> Euro");
		rechnenButton.addActionListener(this);
		add(rechnenButton, BorderLayout.CENTER);		
	}

	public void actionPerformed( ActionEvent e ) {
	
		double dm = String2Double( ursprungsBetrag.getText() );
		double euro = DM2Euro( dm );
		
		euroBetrag.setText( Double.toString(euro) );	
	}
	
	private double String2Double( String str ) {
		double retValue = 0.0;
		
		try {
			Double temp = Double.valueOf(str);
			retValue = temp.doubleValue();
		}
		catch( NumberFormatException e ) {
		}
		
		return(retValue);	
	}	
	
	private double DM2Euro( double dm ) {
		final BigDecimal kurs = new BigDecimal(1.95583);
		BigDecimal betrag = new BigDecimal(dm);
		BigDecimal result = null;
		
		try {
			result = betrag.divide( kurs, 2, BigDecimal.ROUND_HALF_UP );
		}
		catch (Exception e){
		}
	
		return( result != null ? result.doubleValue() : 0.0 );		
	}
}
			