import java.awt.*;
import java.applet.Applet;

public class WahlErgebnis3 extends Applet {
	
	private String[] parteien;
	private Color[] parteiFarben;
	private String[] prozente;
	private Image img;
		
	private Font f;
	private int height;
	private int maxParteiLength;
	
	private int anzahlParteien;
	
	public void init() {
		// Parameter einlesen
		anzahlParteien = getAnzahlParteien();	// Ermittelt Anzahl der Parteien
		getParametersParteien();				// Liest Parteibezeichnungen ein				
		getParametersProzente();				// Liest Prozente ein
		getParametersFarben();					// Liest Parteifarben ein
		
		String bildName;
		
		if( (bildName = getParameter("Bild")) != null ) {
			img = getImage( getCodeBase(), bildName );	
		}
		
		// Einmalige Initialisierungen
		f = new Font("SansSerif", Font.BOLD, 14);
		setFont(f);
		FontMetrics fm = getFontMetrics(f);
		height = fm.getHeight();
			
		for( int i = 0; i < parteien.length; i++ ) {
			int len = fm.stringWidth(parteien[i]);
			if( maxParteiLength < len )
				maxParteiLength = len;
		}

	}

	public int getAnzahlParteien() {
		int anzahl = 0;
		
		// Mehr als 100 sollen es ja wohl nicht sein ...
		for( ; anzahl < 100; anzahl++ ) {
			String pWert = "Partei" + anzahl;
			String partei = getParameter( pWert );
			
			if( partei == null ) // Schluss!!!
				break;
		}	
		
		return( anzahl );	
	}
	
	public void getParametersParteien() {
		// Array deklarieren
		parteien = new String[ anzahlParteien ];
		
		for(int i=0; i < parteien.length; i++) {
			String pWert = "Partei" + i;
			parteien[i] = getParameter( pWert );
			// Wenn Parameter nicht vorhanden, dann ist Schluss
			if( parteien[i] == null )
				break;	
		}		
	}
	
	public void getParametersProzente() {
		// Array deklarieren
		prozente = new String[ anzahlParteien ];
		
		for(int i=0; i < prozente.length; i++) {
			String pWert = "Prozent" + i;
			prozente[i] = getParameter( pWert );
			// Wenn Parameter nicht vorhanden, dann ist Schluss
			if( prozente[i] == null )
				break;
		}				
	}
	
	public void getParametersFarben() {
		// Array deklarieren
		parteiFarben = new Color[ anzahlParteien ];
		
		for(int i=0; i < parteiFarben.length; i++) {
			String pWert = "Farbe" + i;

			String farbe = getParameter( pWert );
			// Wenn Parameter nicht vorhanden, dann ist Schluss
			if( farbe == null )
				break;
			else {
				if( farbe.equals("Rot") )
					parteiFarben[i] = Color.red;
				else if( farbe.equals("Schwarz") )
					parteiFarben[i] = Color.black;
				else if( farbe.equals("Gruen") )
					parteiFarben[i] = Color.green;
				else if( farbe.equals("Blau") )
					parteiFarben[i] = Color.blue;
				else
					parteiFarben[i] = Color.lightGray;
			}
		}					
	}
	
	public void paint( Graphics g ) {
		// Position Text	
		int xpos1 = 10;
		// Position Balken
		int xpos2 = xpos1 + maxParteiLength + 5;
		// Vertikale Startposition
		int ypos = 10 + height;
		int scale = 5;
		int imgx = 0; 
		int imgy = 0;
		if( img != null ) {
			g.drawImage( img, xpos1, ypos, this );
			imgx = img.getWidth(this);
			imgy = img.getHeight(this);
		}
		
		g.setColor( Color.blue );
		g.drawString("Wahlergebnisse", xpos1 + imgx + 5, ypos + imgy/2);
		
		ypos += imgy+height;
		for( int i = 0; i < parteien.length; i++ ) {
			// Textausgabe
			g.setColor(Color.black);		
			g.drawString( parteien[i], xpos1, ypos );
	
			// Balkenausgabe
			double wert = Double.parseDouble( prozente[i] );
			int balkenLen = (int)(wert*scale);
			g.setColor(parteiFarben[i]);
			g.fillRect( xpos2, ypos-height/2, balkenLen, 10 );	
	
			// Prozentausgabe
			g.setColor(Color.black);		
			g.drawString( prozente[i] + " %", xpos2+balkenLen+5, ypos );			
	
			// Zeilensprung
			ypos += height+5;
		}
		
	}		
}
																						