import java.awt.*;
import java.applet.Applet;
import java.util.*;

public class WahlErgebnis2a extends Applet {
	
	Vector parteien;

	private Font f;
	private int height;
	private int maxParteiLength;
		
	public void init() {
		// Parameter einlesen
		getParameters();

		// Einmalige Initialisierungen
		f = new Font("SansSerif", Font.BOLD, 14);
		setFont(f);
		FontMetrics fm = getFontMetrics(f);
		height = fm.getHeight();
			
		for( Enumeration e = parteien.elements(); e.hasMoreElements(); ) {
		
			Partei p = (Partei)e.nextElement();
			int len = fm.stringWidth( p.getName() );
			if( maxParteiLength < len )
				maxParteiLength = len;
		}

	}

	public void getParameters() {

		parteien = new Vector();
		
		int i = 0;
		while( true ) {
		
			String pWert = "Param"+i;
			String paramString	= getParameter( pWert );	

			if( paramString == null )
				break;
			else {
				Partei temp = new Partei( paramString );
				parteien.addElement( temp );					
			}

			i++;
		}
	}
	
	private double String2Double( String str ) {
		double retValue = 0.0;
		
		try {
			Double temp = Double.valueOf(str);
			retValue = temp.doubleValue();
		}
		catch( NumberFormatException e ) {
		}
		
		return(retValue);	
	}
				
	public void paint( Graphics g ) {
		// Position Text	
		int xpos1 = 10;
		// Position Balken
		int xpos2 = xpos1 + maxParteiLength + 5;
		// Vertikale Startposition
		int ypos = 10 + height;
		int scale = 5;
				
		for( Enumeration e = parteien.elements(); e.hasMoreElements(); ) {
		
			Partei p = (Partei)e.nextElement();
			
			// Textausgabe
			g.setColor(Color.black);		
			g.drawString( p.getName(), xpos1, ypos );
	
			// Balkenausgabe
			double wert = String2Double( p.getProzente() );
			int balkenLen = (int)(wert*scale);
			g.setColor( p.getFarbe() );
			g.fillRect( xpos2, ypos-height/2, balkenLen, 10 );	
	
			// Prozentausgabe
			g.setColor(Color.black);		
			g.drawString( p.getProzente() + " %", xpos2+balkenLen+5, ypos );			
	
			// Zeilensprung
			ypos += height+5;
		}
	}		
}
																							