import java.awt.*;
import java.applet.Applet;

public class WahlErgebnis extends Applet {
	
	private String[] parteien = {
		"CDU",
		"SPD",
		"Grne/B90",
		"FDP",
		"Sonstige"
	};
	
	private Color[] parteiFarben = {
		Color.black,
		Color.red,
		Color.green,
		Color.blue,
		Color.lightGray
	};
	
	private double[] prozente = {
		40.0, 30.0, 5.0, 5.0, 20.0
	};
	
	private Font f;
	private int height;
	private int maxParteiLength;
	
	public void init() {
	
		// Einmalige Initialisierungen
		f = new Font("SansSerif", Font.BOLD, 14);
		setFont(f);
		FontMetrics fm = getFontMetrics(f);
		height = fm.getHeight();
			
		for( int i = 0; i < parteien.length; i++ ) {
			int len = fm.stringWidth(parteien[i]);
			if( maxParteiLength < len )
				maxParteiLength = len;
		}

	}
	
	public void paint( Graphics g ) {
		// Position Text	
		int xpos1 = 10;
		// Position Balken
		int xpos2 = xpos1 + maxParteiLength + 5;
		// Vertikale Startposition
		int ypos = 10 + height;
		int scale = 5;
				
		for( int i = 0; i < parteien.length; i++ ) {
			// Textausgabe
			g.setColor(Color.black);		
			g.drawString( parteien[i], xpos1, ypos );
	
			// Balkenausgabe
			int balkenLen = (int)(prozente[i]*scale);
			g.setColor(parteiFarben[i]);
			g.fillRect( xpos2, ypos-height/2, balkenLen, 10 );	
	
			// Prozentausgabe
			g.setColor(Color.black);		
			g.drawString( Double.toString(prozente[i]) + " %", xpos2+balkenLen+5, ypos );			
	
			// Zeilensprung
			ypos += height+5;
		}
	}
}
		