import java.util.*;
import java.awt.*;

public class Partei {

	private String parteiName;
	private String parteiProzente;
	private Color parteiFarbe;
	
	public Partei( String name, String prozente, int r, int g, int b) {
		parteiName = name;
		parteiProzente = prozente;
		parteiFarbe = new Color(r,g,b);	
	}
	
	public Partei( String paramStr ) {
		tokenize( paramStr );	
	}
	
	public void setName( String name ) {
		parteiName = name;	
	}
	
	public void setProzente( String prozente ) {
		parteiProzente = prozente;
	}
	
	public void setFarbe( int r, int g, int b ) {
		parteiFarbe = new Color( r, g, b );	
	}
	
	public String getName() {
		return( parteiName );	
	}
	
	public String getProzente() {
		return( parteiProzente );	
	}
	
	public Color getFarbe() {
		return( parteiFarbe );	
	}
	
	private void tokenize( String paramStr ) {
		int red = 0;
		int green = 0;
		int blue = 0;
		
		StringTokenizer st = new StringTokenizer( paramStr, "," );
		
		int num = st.countTokens();
		
		for(int i = 0; i < num; i++) {
			if( st.hasMoreTokens() ) {
				String token = st.nextToken();
				
				switch(i) {
					case 0:
						parteiName = token;
						break;
					case 1:
						parteiProzente = token;
						break;
					case 2:
						red = Integer.parseInt(token);
						break;
					case 3:
						green = Integer.parseInt(token);
						break;
					case 4:
						blue = Integer.parseInt(token);
						break;
					default:
						break;
				}
			}			
		}

		setFarbe( red, green, blue );			
	}
				
}
