import java.awt.*;
import java.applet.Applet;

public class MusterAnimation2 extends Applet implements Runnable {

	private Thread animation;
	private int step;
	private int maxSteps;

	Dimension size;
	Image buffer;
	Graphics bufferGraphics;
	
	public void init() {
		maxSteps = 100;

		size = this.getSize();
		buffer = this.createImage(size.width, size.height);
		bufferGraphics = buffer.getGraphics();
	}

	public void start() {
	
		if( animation == null ) {
			animation = new Thread( this );
			step = 0;
			animation.start();
		}
	}
	
	public void stop() {
	
		if( animation != null ) {
			animation = null;	
		}
	}
	
	public void run() {

		while( true ) {
			
			repaint();
			step++;
			if( step == maxSteps ){
				step = 0;
			}
			
			try {		
				animation.sleep(10);
			}
			catch( InterruptedException e ) {
				break;
			}
		}
	}
	
	public void update( Graphics g ) {
		paint(g);
	}
	
	public void paint( Graphics g ) {
		
		bufferGraphics.setColor(Color.white);
		bufferGraphics.fillRect(0,0,size.width,size.height);
		
		bufferGraphics.setColor(Color.red);
		bufferGraphics.fillRect( 10, 10, step*3, 100 );
		g.drawImage(buffer,0,0,this);
	}
}
