import java.awt.*;
import java.applet.Applet;

public class MusterAnimation extends Applet implements Runnable {

	private Thread animation;
	private int step;
	private int maxSteps;
	
	public void init() {
		maxSteps = 100;
	}

	public void start() {
	
		if( animation == null ) {
			animation = new Thread( this );
			step = 0;
			animation.start();
		}
	}
	
	public void stop() {
	
		if( animation != null ) {
			animation = null;	
		}
	}
	
	public void run() {

		while( step < maxSteps ) {
			step++;
			repaint();
			try {		
				animation.sleep(100);
			}
			catch( InterruptedException e ) {
				break;
			}
		}
	}
	
	public void update( Graphics g ) {
		paint(g);
	}
	
	public void paint( Graphics g ) {

		g.fillRect( 10, 10, step*5, 100 );
	}
	
}
