//******************************************************************************
// NaviBar.java:	Applet
//******************************************************************************

import java.applet.*;
import java.awt.*;
import java.net.*;
import java.lang.Integer;

//==============================================================================
// Hauptklasse fr Applet NaviBar
//==============================================================================
public class NaviBar extends Applet
{

	
//  Variablen 
	
	boolean istPause = false;
	Button vor,zurueck,pause;
	NaviTimer naechste,letzte;
	String naechsteP,letzteP;
	URL naechsteURL;
	URL letzteURL;
	int zeit;
	 

//  Konstruktor
	
	public NaviBar()
	{
	}


//  Appletinfo
	
	public String getAppletInfo()
	{
		return "Name: NaviBar\n";
	}


//  Initialisierung

	public void init()
	{
	//	Gre festlegen
		resize(160, 30);

	//	Buttons erstellen
		vor = new Button("Vor");
		zurueck = new Button("Zurck");
		pause = new Button("Pause");
		
		add(zurueck);
		add(pause);
		add(vor);

	//	Parameter fr nchste und letzte Seite einlesen	
		naechsteP = getParameter("NaechsteSeite");
		letzteP = getParameter("LetzteSeite");

	//  Parameter fr Hintergrundfarbe einlesen	
		String farbeS = getParameter("Farbe");
				
	//  Falls keine Hintergrundfarbe angegeben ist, wei verwenden
		if (farbeS != null)
		{
		//	Farbformat korrekt ?
			try
			{
				int farbe = Integer.parseInt(farbeS, 16);
				setBackground(new Color(farbe));
			}
		//	sonst Hintergrund auch wei
			catch (NumberFormatException e)
			{
				setBackground(Color.white);
			}
		}
		else
		{
			setBackground(Color.white);
		}

	//	Parameter fr Anzeigedauer der Seite einlesen und
	//	gegebenenfalls auf 0 setzen
		if (getParameter("Zeit") == null)
		{
			zeit = 0;
		}
		else
		{
		//	Zeit korrekt angegeben ?
			try { zeit = Integer.parseInt(getParameter("Zeit")); }
		//	sonst Zeit = 0 -> kein Timer
			catch (NumberFormatException e)	{ zeit = 0; }
		}

	//	berprfung ob nchstes Dokument mit relativer oder absoluter URL angegeben wurde
	//	Button 'vor' entfernen, wenn URL ungltig
	//	absolute URL (mit Protokollangabe)?
		if (naechsteP.startsWith("http://") || naechsteP.startsWith("file://"))
		{
			try
			{
				naechsteURL = new URL(naechsteP);
				naechste = new NaviTimer(getAppletContext(), naechsteURL, zeit);
			}
			catch (Exception e) { remove(vor); }
		}
		else
		{
			try
			{
				naechsteURL = new URL(getCodeBase(), naechsteP);
				naechste = new NaviTimer(getAppletContext(), naechsteURL, zeit);
			}
			catch (Exception e) { remove(vor); }
		}

	//	berprfung ob vorheriges Dokument mit relativer oder absoluter URL angegeben wurde
	//	Button 'zurueck' entfernen, wenn URL ungltig
	//	absolute URL (mit Protokollangabe)?
		if (letzteP.startsWith("http://") || letzteP.startsWith("file://"))
		{
			try
			{
				letzteURL = new URL(letzteP);
				letzte = new NaviTimer(getAppletContext(), letzteURL, 0);
			}
			catch (Exception e) { remove(zurueck); }
		}
		else
		{
			try
			{
				letzteURL = new URL(getCodeBase(), letzteP);
				letzte = new NaviTimer(getAppletContext(), letzteURL, 0);
			}
			catch (Exception e) { remove(zurueck); }
		}
	}

//	aufrumen, wenn Applet beendet wird, hier nicht bentigt	
	public void destroy() {}

	// NaviBar Zeichnungsbehandlungsroutine
	// hier nicht bentigt, da Komponenten automatisch angezeigt werden
	public void paint(Graphics g) {}

//	Timerobjekte beim Starten des Applets erstellen
	public void start()
	{
		if (naechste == null) naechste = new NaviTimer(getAppletContext(), naechsteURL, zeit);
		if (letzte == null) letzte = new NaviTimer(getAppletContext(), letzteURL, 0);
	}

//	Applet beim Verlassen der Seite zurcksetzen
	public void stop()
	{
		naechste.stop();
		naechste = null;
		letzte = null;
		istPause = false;
		pause.setLabel("Pause");
	}

//	berprfung, ob ein Button gedrckt wurde
	public boolean action(Event evt, Object obj)
	{ 
		if(evt.target instanceof Button)
		{
			return mausAktion((Button)evt.target);
		}
		return false;
	}

//	Reaktion auf einen gedrckten Button
    public boolean mausAktion(Button b)
	{
		if (b == zurueck)
		{
			//	letzte Seite ffnen
	            letzte.oeffneSeite();
				return true;
		}
		else if (b == vor)
		{
			//	nchste Seite ffnen
	            naechste.oeffneSeite();
				return true;
		}
		else if (b == pause)
		{
		//	Buttonlabel und Timerzustand umkehren
			if (istPause == false)
			{
			//	Timer anhalten			  
				istPause = true;
				naechste.stop();
				pause.setLabel("Start");
				repaint();
			}
			else
			{
			//	Timer neu starten
				istPause = false;
				naechste.start();
				pause.setLabel("Pause");
				repaint();
			}
			return true;
		}
		else return false;
	}

}
